<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:MSHelp="http://msdn.microsoft.com/mshelp" xmlns:saxon="http://icl.com/saxon" extension-element-prefixes="saxon">
	<xsl:param name="DevLang">Delphi</xsl:param>
	<xsl:output encoding="iso-8859-1" method="xml" indent="yes"/>
	<xsl:strip-space elements="*"/>
	<xsl:variable name="vars" select="document('vars.xml')"/>
	<xsl:variable name="lc">abcdefghijklmnopqrstuvwxyz</xsl:variable>
	<xsl:variable name="uc">ABCDEFGHIJKLMNOPQRSTUVWXYZ </xsl:variable>
	<!-- ################### namespace files ################# -->
	<xsl:template match="/namespace">
		<xsl:variable name="namespace" select="@name"/>
		<xsl:variable name="namespacestring">
			<xsl:value-of select="concat('html/', $namespace)"/>
		</xsl:variable>
		<xsl:variable name="stripped" select="translate($namespacestring, '.', '')"/>
		<xsl:variable name="namespacefile">
			<xsl:value-of select="concat('uncleaned_',$stripped, 'Namespace.htm')"/>
		</xsl:variable>
		<xsl:if test="descendant::api ">
			<xsl:document method="xml" indent="yes" href="{$namespacefile}">
				<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp" DIR="LTR">
					<head>
						<link rel="stylesheet" type="text/css" href="../common/bdshelp.css"/>
						<SCRIPT SRC="../common/linker.js">
							<xsl:text> </xsl:text>
						</SCRIPT>
						<xml>
							<xsl:element name="MSHelp:TOCTitle">
								<xsl:attribute name="Title"><!-- applying templates to the vars node will allow translators to
               change the location of the name element as needed for the grammar of the language --><xsl:apply-templates select="$vars//localizable/namespace/node()"><xsl:with-param name="membername" select="$namespace"/></xsl:apply-templates></xsl:attribute>
							</xsl:element>
							<xsl:element name="MSHelp:RLTitle">
								<xsl:attribute name="Title"><xsl:apply-templates select="$vars//localizable/namespace/node()"><xsl:with-param name="membername" select="$namespace"/></xsl:apply-templates></xsl:attribute>
							</xsl:element>
							<xsl:variable name="linkstring">
								<xsl:value-of select="$namespace"/>
							</xsl:variable>
							<!-- #### calling helplinks #### -->
							<xsl:call-template name="helplinks">
								<xsl:with-param name="linkstring" select="$linkstring"/>
							</xsl:call-template>
							<xsl:value-of select="$vars//localizable/helpattributes"/>
						</xml>
						<META HTTP-EQUIV="Content-Type" Content="text/html; charset=Windows-1252"/>
						<basefont size="2"/>
					</head>
					<body>
						<title>
							<xsl:value-of select="$namespace"/>
						</title>
						<span class="title">
							<xsl:apply-templates select="$vars//localizable/namespace/node()">
								<xsl:with-param name="membername" select="$namespace"/>
							</xsl:apply-templates>
						</span>
						<!-- ######## member classes ########## -->
						<xsl:if test="count(class) > 0">
							<span class="linkList">
								<xsl:value-of select="$vars//localizable/classes"/>
								<xsl:for-each select="class">
									<xsl:sort select="@name"/>
									<span class="listedLink">
										<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
										<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
											<xsl:attribute name="keywords"><xsl:value-of select="concat($namespace,'.',@name)"/></xsl:attribute>
											<xsl:value-of select="@name"/>
										</MSHelp:link>
									</span>
								</xsl:for-each>
							</span>
						</xsl:if>
						<!-- ######## member interfaces ########## -->
						<xsl:if test="count(interface) > 0">
							<span class="linkList">
								<xsl:value-of select="$vars//localizable/interfacesinnamespace"/>
								<xsl:for-each select="interface">
									<xsl:sort select="@name"/>
									<span class="listedLink">
										<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
										<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
											<xsl:attribute name="keywords"><xsl:value-of select="concat($namespace,'.',@name)"/></xsl:attribute>
											<xsl:value-of select="@name"/>
										</MSHelp:link>
									</span>
								</xsl:for-each>
							</span>
						</xsl:if>
						<!-- ######## member types ########## -->
						<xsl:if test="count(type) > 0">
							<span class="linkList">
								<xsl:value-of select="$vars//localizable/types"/>
								<xsl:for-each select="type">
									<xsl:sort select="@name"/>
									<span class="listedLink">
										<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
										<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
											<xsl:attribute name="keywords"><xsl:value-of select="concat($namespace,'.',@name)"/></xsl:attribute>
											<xsl:value-of select="@name"/>
										</MSHelp:link>
									</span>
								</xsl:for-each>
							</span>
						</xsl:if>
						<!-- ######## member routines ########## -->
						<xsl:if test="count(routine) > 0">
							<span class="linkList">
								<xsl:value-of select="$vars//localizable/routines"/>
								<xsl:for-each select="routine">
									<xsl:sort select="@name"/>
									<span class="listedLink">
										<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
										<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
											<xsl:attribute name="keywords"><xsl:value-of select="concat($namespace,'.',@name)"/></xsl:attribute>
											<xsl:value-of select="@name"/>
										</MSHelp:link>
									</span>
								</xsl:for-each>
							</span>
						</xsl:if>
						<!-- ######## member variables ########## -->
						<xsl:if test="count(variable) > 0">
							<span class="linkList">
								<xsl:value-of select="$vars//localizable/variables"/>
								<xsl:for-each select="variable">
									<xsl:sort select="@name"/>
									<span class="listedLink">
										<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
										<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
											<xsl:attribute name="keywords"><xsl:value-of select="concat($namespace,'.',@name)"/></xsl:attribute>
											<xsl:value-of select="@name"/>
										</MSHelp:link>
									</span>
								</xsl:for-each>
							</span>
						</xsl:if>
						<!-- ######## member constants ########## -->
						<xsl:if test="count(constant) > 0">
							<span class="linkList">
								<xsl:value-of select="$vars//localizable/constants"/>
								<xsl:for-each select="constant">
									<xsl:sort select="@name"/>
									<span class="listedLink">
										<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
										<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
											<xsl:attribute name="keywords"><xsl:value-of select="concat($namespace,'.',@name)"/></xsl:attribute>
											<xsl:value-of select="@name"/>
										</MSHelp:link>
									</span>
								</xsl:for-each>
							</span>
						</xsl:if>
						<xsl:call-template name="footer"/>
					</body>
				</html>
			</xsl:document>
			<xsl:apply-templates/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="/namespace/class">
		<!-- ################# Top level class files ################## -->
		<xsl:variable name="classname" select="@name"/>
		<xsl:variable name="namespace" select="@namespace"/>
		<xsl:variable name="classstring">
			<xsl:value-of select="concat('html/', $namespace, $classname)"/>
		</xsl:variable>
		<xsl:variable name="stripped" select="translate($classstring, '.', '')"/>
		<xsl:variable name="classfile">
			<xsl:value-of select="concat('uncleaned_',$stripped, 'Class.htm')"/>
		</xsl:variable>
		<xsl:if test="descendant::api">
			<xsl:document method="xml" indent="yes" href="{$classfile}">
				<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp" DIR="LTR">
					<head>
						<link rel="stylesheet" type="text/css" href="../common/bdshelp.css"/>
						<SCRIPT SRC="../common/linker.js">
							<xsl:text> </xsl:text>
						</SCRIPT>
						<xml>
							<xsl:element name="MSHelp:TOCTitle">
								<xsl:attribute name="Title"><xsl:apply-templates select="$vars//localizable/class/node()"><xsl:with-param name="membername" select="$classname"/></xsl:apply-templates></xsl:attribute>
							</xsl:element>
							<xsl:element name="MSHelp:RLTitle">
								<xsl:attribute name="Title"><xsl:apply-templates select="$vars//localizable/class/node()"><xsl:with-param name="membername" select="$classname"/></xsl:apply-templates></xsl:attribute>
							</xsl:element>
							<xsl:variable name="linkstring">
								<xsl:value-of select="$namespace"/>.<xsl:value-of select="$classname"/>
							</xsl:variable>
							<!-- #### calling helplinks #### -->
							<xsl:call-template name="helplinks">
								<xsl:with-param name="linkstring" select="$linkstring"/>
							</xsl:call-template>
							<xsl:value-of select="$vars//localizable/helpattributes"/>
						</xml>
						<META HTTP-EQUIV="Content-Type" Content="text/html; charset=Windows-1252"/>
						<basefont size="2"/>
					</head>
					<!--####### content block for class files #########-->
					<body>
						<title>
							<xsl:apply-templates select="$vars//localizable/class/node()">
								<xsl:with-param name="membername" select="$classname"/>
							</xsl:apply-templates>
						</title>
						<span class="title">
							<xsl:apply-templates select="$vars//localizable/class/node()">
								<xsl:with-param name="membername" select="$classname"/>
							</xsl:apply-templates>
						</span>
						<!-- #### descrShort ####-->
						<xsl:for-each select="api/descrShort">
							<xsl:apply-templates select="."/>
						</xsl:for-each>
						<xsl:call-template name="referencelink">
							<xsl:with-param name="type" select="$vars//localizable/namespace"/>
							<xsl:with-param name="namespace" select="$namespace"/>
							<xsl:with-param name="value" select="$namespace"/>
						</xsl:call-template>
						<xsl:call-template name="labelsyntax"/>
						<span class="list">
							<p>
								<span class="li">
									<span class="syntax">
										<xsl:call-template name="containersyntax">
											<xsl:with-param name="type">class</xsl:with-param>
										</xsl:call-template>
									</span>
								</span>
							</p>
						</span>
						<!-- #### descrLong #### -->
						<xsl:variable name="longdescription" select="normalize-space (api/descrLong)"/>
						<xsl:if test="string-length(string($longdescription)) > 1">
							<xsl:call-template name="labeldesc"/>
							<xsl:for-each select="api/descrLong">
								<span class="descrLong">
									<xsl:apply-templates select="."/>
								</span>
							</xsl:for-each>
						</xsl:if>
						
						
						<xsl:variable name="fields">
							<xsl:for-each select="members/field">
								<field>
								<name><xsl:value-of select="@name"/></name>
								<type><xsl:value-of select="@type"/></type>
								<description><xsl:value-of select="api/descrShort/para"/></description>
								</field>
							</xsl:for-each>
						</xsl:variable>
						
						
						
						<xsl:if test="$fields/field/description[text()]">
						<span class="tableTitle"><xsl:value-of select="$vars//localizable/fieldSummary"/></span>
						<span class="table">
							<table class="regular">
								<span class="tr">
									<tr>
										<th><xsl:value-of select="$vars//localizable/fieldName"/></th>
										<th><xsl:value-of select="$vars//localizable/fieldType"/></th>
										<th><xsl:value-of select="$vars//localizable/fieldDescription"/></th>
									</tr>
								</span>
								<xsl:for-each select="$fields/field[description/text()!='']">
								<span class="tr">
									<tr>
										<td class="regular">
											<span class="tablePara"><xsl:value-of select="name"/></span>
										</td>
										<td class="regular">
											<span class="tablePara"><xsl:value-of select="type"/></span>
										</td>
										<td class="regular">
											<span class="tablePara"><xsl:value-of select="description"/></span>
										</td>
									</tr>
								</span>
								</xsl:for-each>
							</table>
						</span>
					</xsl:if>

						<!-- #### Hierarchy ####-->
						<span class="linkList">
							<xsl:value-of select="$vars//localizable/hierarchy"/>
							<xsl:for-each select="hierarchy">
								<xsl:for-each select="ancestor">
									<xsl:sort select="position()" data-type="number" order="descending"/>
									<xsl:if test="@docset='microsoft'">
										<span class="listedLink">
											<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
											<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
												<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class"/></xsl:attribute>
												<xsl:value-of select="namespace"/>.<xsl:value-of select="class"/>
												<xsl:call-template name="msicon"/>
											</MSHelp:link>
										</span>
									</xsl:if>
									<xsl:if test="@docset='borland'">
										<span class="listedLink">
											<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
											<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
												<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class"/></xsl:attribute>
												<xsl:value-of select="namespace"/>.<xsl:value-of select="class"/>
											</MSHelp:link>
										</span>
									</xsl:if>
								</xsl:for-each>
							</xsl:for-each>
						</span>
						<!-- #### Implemented Interfaces #### -->
						<xsl:variable name="implementslinknode">
							<xsl:for-each select="interfaces">
								<xsl:for-each select="implements">
									<span class="listedLink">
										<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
										<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
											<xsl:variable name="fullname">
												<xsl:if test="@namespace">
													<xsl:value-of select="@namespace"/>
													<xsl:text>.</xsl:text>
												</xsl:if>
												<xsl:value-of select="@name"/>
											</xsl:variable>
											<xsl:attribute name="keywords"><xsl:value-of select="$fullname"/></xsl:attribute>
											<xsl:value-of select="$fullname"/>
											<xsl:if test="starts-with($fullname, 'System.')">
												<xsl:call-template name="msicon"/>
											</xsl:if>
										</MSHelp:link>
									</span>
								</xsl:for-each>
							</xsl:for-each>
						</xsl:variable>
						<!-- leave out the heading if there are no implemented interfaces. -->
						<xsl:if test="boolean($implementslinknode//MSHelp:link)">
							<!-- #### this sorts the 2 types of links above #### -->
							<span class="linkList">
								<xsl:value-of select="$vars//localizable/interfaces"/>
								<xsl:for-each select="$implementslinknode/span">
									<xsl:sort select="MSHelp:link/text()"/>
									<xsl:copy-of select="."/>
								</xsl:for-each>
							</span>
						</xsl:if>
						<!-- make new files for members -->
						<xsl:if test="members/property [descendant::api] | members/method [descendant::api] | members/event [descendant::api]
                                                      | propertylinks/propertylink | methodlinks/methodlink 
                                                      | eventlinks/eventlink">
							<span class="linkList">
								<xsl:value-of select="$vars//localizable//linkList"/>
								<xsl:call-template name="insertmemberlinks">
									<xsl:with-param name="namespace" select="$namespace"/>
									<xsl:with-param name="containername" select="$classname"/>
									<xsl:with-param name="membertype" select="'All'"/>
								</xsl:call-template>
							</span>
							<xsl:call-template name="makemembersfile">
								<xsl:with-param name="namespace" select="$namespace"/>
								<xsl:with-param name="containername" select="$classname"/>
								<xsl:with-param name="containertype" select="'Class'"/>
								<xsl:with-param name="stripped" select="$stripped"/>
							</xsl:call-template>
							<xsl:if test="members/property | propertylinks/propertylink">
								<!-- ##################### PROPERTIES FILE ###################### -->
								<xsl:variable name="propertiesfile">
									<xsl:value-of select="concat('uncleaned_',$stripped, 'Properties.htm')"/>
								</xsl:variable>
								<xsl:document method="xml" indent="yes" href="{$propertiesfile}">
									<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp" DIR="LTR">
										<head>
											<link rel="stylesheet" type="text/css" href="../common/bdshelp.css"/>
											<SCRIPT SRC="../common/linker.js">
												<xsl:text> </xsl:text>
											</SCRIPT>
											<xml>
												<xsl:element name="MSHelp:TOCTitle">
													<xsl:attribute name="Title"><xsl:apply-templates select="$vars//localizable/properties/node()"><xsl:with-param name="membername" select="$classname"/></xsl:apply-templates></xsl:attribute>
												</xsl:element>
												<xsl:element name="MSHelp:RLTitle">
													<xsl:attribute name="Title"><xsl:apply-templates select="$vars//localizable/properties/node()"><xsl:with-param name="membername" select="$classname"/></xsl:apply-templates></xsl:attribute>
												</xsl:element>
												<xsl:variable name="linkstring">
													<xsl:value-of select="$namespace"/>.<xsl:value-of select="$classname"/>
													<xsl:text/>
													<xsl:value-of select="$vars//localizable/properties"/>
												</xsl:variable>
												<!-- #### calling helplinks #### -->
												<xsl:call-template name="helplinks">
													<xsl:with-param name="linkstring" select="$linkstring"/>
												</xsl:call-template>
												<xsl:value-of select="$vars//localizable/helpattributes"/>
											</xml>
											<META HTTP-EQUIV="Content-Type" Content="text/html; charset=Windows-1252"/>
											<basefont size="2"/>
										</head>
										<!--####### content block for class files #########-->
										<body>
											<title>
												<xsl:apply-templates select="$vars//localizable/properties/node()">
													<xsl:with-param name="membername" select="$classname"/>
												</xsl:apply-templates>
											</title>
											<span class="title">
												<xsl:apply-templates select="$vars//localizable/properties/node()">
													<xsl:with-param name="membername" select="$classname"/>
												</xsl:apply-templates>
											</span>
											<!-- ########## propertylinks ########## -->
											<!-- collecting in a variable so they can all be sorted-->
											<xsl:variable name="proplinknode">
												<!-- ########## property links ######### -->
												<xsl:for-each select="propertylinks/propertylink[not(property=following-sibling::propertylink/property) and not(../../members/property/@name=property)]">
													<xsl:variable name="proplinkname" select="property/text()"/>
													<xsl:if test="not(../../members/property[@name=$proplinkname])">
														<xsl:element name="inheritedlink">
															<xsl:copy-of select="@declaring_interface"/>
															<xsl:attribute name="namespace"><xsl:value-of select="namespace"/></xsl:attribute>
															<xsl:attribute name="class"><xsl:value-of select="class"/></xsl:attribute>
															<xsl:if test="@docset='microsoft'">
																<link>
																	<span class="link">
																		<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																		<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																			<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="property"/></xsl:attribute>
																			<xsl:value-of select="property"/>
																			<xsl:if test="boolean(@declaring_interface)">
																				<span class="pt">
																					<xsl:text> (</xsl:text>
																					<xsl:value-of select="@declaring_interface"/>
																					<xsl:text>)</xsl:text>
																				</span>
																			</xsl:if>
																		</MSHelp:link>
																	</span>
																	<mslink>
																		<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																		<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																			<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="property"/></xsl:attribute>
																			<xsl:apply-templates select="$vars//localizable/Inheritedfrom/node()">
																				<xsl:with-param name="membername">
																					<xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>
																				</xsl:with-param>
																			</xsl:apply-templates>
																			<xsl:call-template name="msicon"/>
																		</MSHelp:link>
																	</mslink>
																	<xsl:copy-of select="descrShort"/>
																</link>
															</xsl:if>
															<xsl:if test="@docset='borland'">
																<link>
																	<span class="link">
																		<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																		<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																			<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="property"/></xsl:attribute>
																			<xsl:value-of select="property"/>
																			<xsl:if test="boolean(@declaring_interface)">
																				<span class="pt">
																					<xsl:text> (</xsl:text>
																					<xsl:value-of select="@declaring_interface"/>
																					<xsl:text>)</xsl:text>
																				</span>
																			</xsl:if>
																		</MSHelp:link>
																	</span>
																	<xsl:copy-of select="descrShort"/>
																</link>
															</xsl:if>
														</xsl:element>
													</xsl:if>
												</xsl:for-each>
												<!-- ########## member properties ########-->
												<!--avoids repeating indexers which are "overloaded" -->
												<xsl:for-each select="members/property[not(@name=following-sibling::property/@name)]">
													<link>
														<span class="link">
															<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
															<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																<xsl:attribute name="keywords"><xsl:value-of select="$namespace"/>.<xsl:value-of select="$classname"/>.<xsl:value-of select="@name"/></xsl:attribute>
																<xsl:value-of select="@name"/>
																<xsl:if test="boolean(@declaring_interface)">
																	<span class="pt">
																		<xsl:text> (</xsl:text>
																		<xsl:value-of select="@declaring_interface"/>
																		<xsl:text>)</xsl:text>
																	</span>
																</xsl:if>
															</MSHelp:link>
														</span>
														<xsl:copy-of select="./api/descrShort"/>
													</link>
												</xsl:for-each>
											</xsl:variable>
											<!-- locally-documented properties -->
											<xsl:if test="boolean($proplinknode/link/span/MSHelp:link | $proplinknode/inheritedlink[@declaring_interface]/link/span/MSHelp:link)">
												<span class="linkList">
													<xsl:apply-templates select="$vars//localizable/Propertiesof/node()">
														<xsl:with-param name="membername" select="$classname"/>
													</xsl:apply-templates>
													<table class="regular">
														<xsl:for-each select="$proplinknode/link/span | $proplinknode/inheritedlink[@declaring_interface]/link/span">
															<xsl:sort select="MSHelp:link/text()"/>
															<tr>
																<td class="regular">
																	<span class="tablePara"><xsl:copy-of select="."/></span>
																</td>
																<td class="regular">
																	<span class="tablePara"><xsl:copy-of select="../descrShort/*"/>
																	<xsl:copy-of select="../mslink"/></span>
																</td>
															</tr>
														</xsl:for-each>
													</table>
												</span>
											</xsl:if>
											<!-- inherited properties -->
											<xsl:for-each select="hierarchy/ancestor">
												<xsl:variable name="ancestorclass">
													<xsl:value-of select="class"/>
												</xsl:variable>
												<xsl:if test="$proplinknode/inheritedlink[@class=$ancestorclass and not (@declaring_interface)]">
													<span class="linkList">
														<xsl:value-of select="$vars//localizable/propertiesinheritedfrom"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="concat(namespace,'.',class)"/>
														<table class="regular">
															<xsl:for-each select="$proplinknode/inheritedlink[@class=$ancestorclass and not (@declaring_interface)]/link/span">
																<xsl:sort select="MSHelp:link/text()"/>
																<tr>
																	<td class="regular">
																		<span class="tablePara"><xsl:copy-of select="."/></span>
																	</td>
																	<td class="regular">
																		<span class="tablePara"><xsl:copy-of select="../descrShort/*"/>
																		<xsl:copy-of select="../mslink"/></span>
																	</td>
																</tr>
															</xsl:for-each>
														</table>
													</span>
												</xsl:if>
											</xsl:for-each>
											<span class="linkList">
												<xsl:value-of select="$vars//localizable//linkList"/>
												<xsl:call-template name="insertparentlinks">
													<xsl:with-param name="namespace" select="$namespace"/>
													<xsl:with-param name="containername" select="$classname"/>
													<xsl:with-param name="containertype" select=" 'Class'"/>
												</xsl:call-template>
												<xsl:call-template name="insertmemberlinks">
													<xsl:with-param name="namespace" select="$namespace"/>
													<xsl:with-param name="containername" select="$classname"/>
													<xsl:with-param name="membertype" select="'Property'"/>
												</xsl:call-template>
											</span>
											<xsl:call-template name="footer"/>
										</body>
									</html>
								</xsl:document>
							</xsl:if>
							<xsl:if test="members/method | methodlinks/methodlink">
								<!-- ##################### METHODS FILE ###################### -->
								<xsl:variable name="methodsfile">
									<xsl:value-of select="concat('uncleaned_',$stripped, 'Methods.htm')"/>
								</xsl:variable>
								<xsl:document method="xml" indent="yes" href="{$methodsfile}">
									<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp" DIR="LTR">
										<head>
											<link rel="stylesheet" type="text/css" href="../common/bdshelp.css"/>
											<SCRIPT SRC="../common/linker.js">
												<xsl:text> </xsl:text>
											</SCRIPT>
											<xml>
												<xsl:element name="MSHelp:TOCTitle">
													<xsl:attribute name="Title"><xsl:value-of select="$classname"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/methods"/></xsl:attribute>
												</xsl:element>
												<xsl:element name="MSHelp:RLTitle">
													<xsl:attribute name="Title"><xsl:value-of select="$classname"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/methods"/></xsl:attribute>
												</xsl:element>
												<xsl:variable name="linkstring">
													<xsl:value-of select="$namespace"/>.<xsl:value-of select="$classname"/>
													<xsl:text> </xsl:text>
													<xsl:value-of select="$vars//localizable/methods"/>
												</xsl:variable>
												<!-- #### calling helplinks #### -->
												<xsl:call-template name="helplinks">
													<xsl:with-param name="linkstring" select="$linkstring"/>
												</xsl:call-template>
												<xsl:value-of select="$vars//localizable/helpattributes"/>
											</xml>
											<META HTTP-EQUIV="Content-Type" Content="text/html; charset=Windows-1252"/>
											<basefont size="2"/>
										</head>
										<!--####### content block for class files #########-->
										<body>
											<title>
												<xsl:value-of select="$classname"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="$vars//localizable/methods"/>
											</title>
											<span class="title">
												<xsl:value-of select="$classname"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="$vars//localizable/methods"/>
											</span>
											<!-- ########## methodlinks ########## -->
											<!-- collecting in a variable so they can all be sorted-->
											<xsl:variable name="methodlinknode">
												<!-- ########## method links ######### -->
												<xsl:for-each select="methodlinks/methodlink[not(method=following-sibling::methodlink/method) and not(../../members/method/@name=method)]">
													<xsl:variable name="methlinkname" select="method/text()"/>
													<xsl:if test="not(../../members/method[@name=$methlinkname])">
														<xsl:element name="inheritedlink">
															<xsl:copy-of select="@declaring_interface"/>
															<xsl:attribute name="namespace"><xsl:value-of select="namespace"/></xsl:attribute>
															<xsl:attribute name="class"><xsl:value-of select="class"/></xsl:attribute>
															<xsl:if test="@docset='microsoft'">
																<link>
																	<span class="link">
																		<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																		<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																			<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="method"/></xsl:attribute>
																			<xsl:value-of select="method"/>
																			<xsl:if test="count(syntax)&gt;1">
																				<span class="pt">
																					<xsl:text> (</xsl:text>
																					<xsl:value-of select="$vars//localizable/overloaded"/>
																					<xsl:text>)</xsl:text>
																				</span>
																			</xsl:if>
																			<xsl:if test="boolean(@declaring_interface)">
																				<span class="pt">
																					<xsl:text> (</xsl:text>
																					<xsl:value-of select="@declaring_interface"/>
																					<xsl:text>)</xsl:text>
																				</span>
																			</xsl:if>
																		</MSHelp:link>
																	</span>
																	<mslink>
																		<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																		<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																			<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="method"/></xsl:attribute>
																			<xsl:apply-templates select="$vars//localizable/Inheritedfrom/node()">
																				<xsl:with-param name="membername">
																					<xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>
																				</xsl:with-param>
																			</xsl:apply-templates>
																			<xsl:call-template name="msicon"/>
																		</MSHelp:link>
																	</mslink>
																	<xsl:copy-of select="descrShort"/>
																</link>
															</xsl:if>
															<xsl:if test="@docset='borland'">
																<link>
																	<span class="link">
																		<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																		<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																			<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="method"/></xsl:attribute>
																			<xsl:value-of select="method"/>
																			<xsl:if test="count(syntax)&gt;1">
																				<span class="pt">
																					<xsl:text> (</xsl:text>
																					<xsl:value-of select="$vars//localizable/overloaded"/>
																					<xsl:text>)</xsl:text>
																				</span>
																			</xsl:if>
																			<xsl:if test="boolean(@declaring_interface)">
																				<span class="pt">
																					<xsl:text> (</xsl:text>
																					<xsl:value-of select="@declaring_interface"/>
																					<xsl:text>)</xsl:text>
																				</span>
																			</xsl:if>
																		</MSHelp:link>
																	</span>
																	<xsl:copy-of select="descrShort"/>
																</link>
															</xsl:if>
														</xsl:element>
													</xsl:if>
												</xsl:for-each>
												<!-- ########## member methods ########-->
												<!-- avoids repeating indexers which are "overloaded" -->
												<xsl:for-each select="members/method[not(@name=following-sibling::method/@name)]">
													<link>
														<span class="link">
															<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
															<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																<xsl:attribute name="keywords"><xsl:value-of select="$namespace"/>.<xsl:value-of select="$classname"/>.<xsl:value-of select="@name"/></xsl:attribute>
																<xsl:value-of select="@name"/>
																<xsl:if test="boolean(@declaring_interface)">
																	<span class="pt">
																		<xsl:text> (</xsl:text>
																		<xsl:value-of select="@declaring_interface"/>
																		<xsl:text>)</xsl:text>
																	</span>
																</xsl:if>
															</MSHelp:link>
														</span>
														<xsl:copy-of select="./api/descrShort"/>
													</link>
												</xsl:for-each>
											</xsl:variable>
											<!-- locally-documented methods -->
											<xsl:if test="boolean($methodlinknode/link/span/MSHelp:link | $methodlinknode/inheritedlink[@declaring_interface]/link/span/MSHelp:link)">
												<span class="linkList">
													<xsl:value-of select="$vars//localizable/Methodsof"/>
													<xsl:text> </xsl:text>
													<xsl:value-of select="$classname"/>
													<table class="regular">
														<xsl:for-each select="$methodlinknode/link/span | $methodlinknode/inheritedlink[@declaring_interface]/link/span">
															<xsl:sort select="MSHelp:link/text()"/>
															<tr>
																<td class="regular">
																	<span class="tablePara"><xsl:copy-of select="."/></span>
																</td>
																<td class="regular">
																	<span class="tablePara">
																	<xsl:copy-of select="../descrShort/*"/>
																	<xsl:copy-of select="../mslink"/></span>
																</td>
															</tr>
														</xsl:for-each>
													</table>
												</span>
											</xsl:if>
											<!-- inherited methods -->
											<xsl:for-each select="hierarchy/ancestor">
												<xsl:variable name="ancestorclass">
													<xsl:value-of select="class"/>
												</xsl:variable>
												<xsl:if test="$methodlinknode/inheritedlink[@class=$ancestorclass and not (@declaring_interface)]">
													<span class="linkList">
														<xsl:value-of select="$vars//localizable/methodsinheritedfrom"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="concat(namespace,'.',class)"/>
														<table class="regular">
															<xsl:for-each select="$methodlinknode/inheritedlink[@class=$ancestorclass and not (@declaring_interface)]/link/span">
																<xsl:sort select="MSHelp:link/text()"/>
																<tr>
																	<td class="regular">
																		<span class="tablePara"><xsl:copy-of select="."/></span>
																	</td>
																	<td class="regular">
																		<span class="tablePara">
																		<xsl:copy-of select="../descrShort/*"/>
																		<xsl:copy-of select="../mslink"/>
																		</span>
																	</td>
																</tr>
															</xsl:for-each>
														</table>
													</span>
												</xsl:if>
											</xsl:for-each>
											<span class="linkList">
												<xsl:value-of select="$vars//localizable//linkList"/>
												<xsl:call-template name="insertparentlinks">
													<xsl:with-param name="namespace" select="$namespace"/>
													<xsl:with-param name="containername" select="$classname"/>
													<xsl:with-param name="containertype" select="'Class'"/>
												</xsl:call-template>
												<xsl:call-template name="insertmemberlinks">
													<xsl:with-param name="namespace" select="$namespace"/>
													<xsl:with-param name="containername" select="$classname"/>
													<xsl:with-param name="membertype" select="'Method'"/>
												</xsl:call-template>
											</span>
											<xsl:call-template name="footer"/>
										</body>
									</html>
								</xsl:document>
							</xsl:if>
							<xsl:if test="members/event | eventlinks/eventlink">
								<!-- ##################### EVENTS FILE ###################### -->
								<xsl:variable name="eventsfile">
									<xsl:value-of select="concat('uncleaned_',$stripped, 'Events.htm')"/>
								</xsl:variable>
								<xsl:document method="xml" indent="yes" href="{$eventsfile}">
									<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp" DIR="LTR">
										<head>
											<link rel="stylesheet" type="text/css" href="../common/bdshelp.css"/>
											<SCRIPT SRC="../common/linker.js">
												<xsl:text> </xsl:text>
											</SCRIPT>
											<xml>
												<xsl:element name="MSHelp:TOCTitle">
													<xsl:attribute name="Title"><xsl:value-of select="$classname"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/events"/></xsl:attribute>
												</xsl:element>
												<xsl:element name="MSHelp:RLTitle">
													<xsl:attribute name="Title"><xsl:value-of select="$classname"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/events"/></xsl:attribute>
												</xsl:element>
												<xsl:variable name="linkstring">
													<xsl:value-of select="$namespace"/>.<xsl:value-of select="$classname"/>
													<xsl:text> </xsl:text>
													<xsl:value-of select="$vars//localizable/events"/>
												</xsl:variable>
												<!-- #### calling helplinks #### -->
												<xsl:call-template name="helplinks">
													<xsl:with-param name="linkstring" select="$linkstring"/>
												</xsl:call-template>
												<xsl:value-of select="$vars//localizable/helpattributes"/>
											</xml>
											<META HTTP-EQUIV="Content-Type" Content="text/html; charset=Windows-1252"/>
											<basefont size="2"/>
										</head>
										<!--####### content block for class files #########-->
										<body>
											<title>
												<xsl:value-of select="$classname"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="$vars//localizable/events"/>
											</title>
											<span class="title">
												<xsl:value-of select="$classname"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="$vars//localizable/events"/>
											</span>
											<!-- ########## eventlinks ########## -->
											<xsl:variable name="eventlinknode">
												<!-- ########## event links ######### -->
												<xsl:for-each select="eventlinks/eventlink[not(event=following-sibling::eventlink/event) and not(../../members/event/@name=event)]">
													<xsl:variable name="eventlinkname" select="event/text()"/>
													<xsl:if test="not(../../members/event[@name=$eventlinkname])">
														<xsl:element name="inheritedlink">
															<xsl:copy-of select="@declaring_interface"/>
															<xsl:attribute name="namespace"><xsl:value-of select="namespace"/></xsl:attribute>
															<xsl:attribute name="class"><xsl:value-of select="class"/></xsl:attribute>
															<xsl:if test="@docset='microsoft'">
																<link>
																	<span class="link">
																		<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																		<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																			<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="event"/></xsl:attribute>
																			<xsl:value-of select="event"/>
																			<xsl:if test="boolean(@declaring_interface)">
																				<span class="pt">
																					<xsl:text> (</xsl:text>
																					<xsl:value-of select="@declaring_interface"/>
																					<xsl:text>)</xsl:text>
																				</span>
																			</xsl:if>
																		</MSHelp:link>
																	</span>
																	<mslink>
																		<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																		<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																			<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="event"/></xsl:attribute>
																			<xsl:value-of select="$vars//localizable/Inheritedfrom"/>
																			<xsl:text> </xsl:text>
																			<xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>
																			<xsl:call-template name="msicon"/>
																		</MSHelp:link>
																	</mslink>
																	<xsl:copy-of select="descrShort"/>
																</link>
															</xsl:if>
															<xsl:if test="@docset='borland'">
																<link>
																	<span class="link">
																		<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																		<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																			<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="event"/></xsl:attribute>
																			<xsl:value-of select="event"/>
																			<xsl:if test="boolean(@declaring_interface)">
																				<span class="pt">
																					<xsl:text> (</xsl:text>
																					<xsl:value-of select="@declaring_interface"/>
																					<xsl:text>)</xsl:text>
																				</span>
																			</xsl:if>
																		</MSHelp:link>
																	</span>
																	<xsl:copy-of select="descrShort"/>
																</link>
															</xsl:if>
														</xsl:element>
													</xsl:if>
												</xsl:for-each>
												<!-- ########## member events ########-->
												<!-- avoids repeating indexers which are "overloaded" -->
												<xsl:for-each select="members/event[not(@name=following-sibling::event/@name)]">
													<link>
														<span class="link">
															<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
															<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																<xsl:attribute name="keywords"><xsl:value-of select="$namespace"/>.<xsl:value-of select="$classname"/>.<xsl:value-of select="@name"/></xsl:attribute>
																<xsl:value-of select="@name"/>
																<xsl:if test="boolean(@declaring_interface)">
																	<span class="pt">
																		<xsl:text> (</xsl:text>
																		<xsl:value-of select="@declaring_interface"/>
																		<xsl:text>)</xsl:text>
																	</span>
																</xsl:if>
															</MSHelp:link>
														</span>
														<xsl:copy-of select="./api/descrShort"/>
													</link>
												</xsl:for-each>
											</xsl:variable>
											<!-- locally-documented events -->
											<xsl:if test="boolean($eventlinknode/link/span/MSHelp:link | $eventlinknode/inheritedlink[@declaring_interface]/link/span/MSHelp:link)">
												<span class="linkList">
													<xsl:value-of select="$vars//localizable/Eventsof"/>
													<xsl:text> </xsl:text>
													<xsl:value-of select="$classname"/>
													<table class="regular">
														<xsl:for-each select="$eventlinknode/link/span | $eventlinknode/inheritedlink[@declaring_interface]/link/span">
															<xsl:sort select="MSHelp:link/text()"/>
															<tr>
																<td class="regular">
																	<span class="tablePara"><xsl:copy-of select="."/></span>
																</td>
																<td class="regular">
																<span class="tablePara">
																	<xsl:copy-of select="../descrShort/*"/>
																	<xsl:copy-of select="../mslink"/>
																	</span>
																</td>
															</tr>
														</xsl:for-each>
													</table>
												</span>
											</xsl:if>
											<!-- inherited events -->
											<xsl:for-each select="hierarchy/ancestor">
												<xsl:variable name="ancestorclass">
													<xsl:value-of select="class"/>
												</xsl:variable>
												<xsl:if test="$eventlinknode/inheritedlink[@class=$ancestorclass and not (@declaring_interface)]">
													<span class="linkList">
														<xsl:value-of select="$vars//localizable/eventsinheritedfrom"/>
														<xsl:text> </xsl:text>
														<xsl:value-of select="concat(namespace,'.',class)"/>
														<table class="regular">
															<xsl:for-each select="$eventlinknode/inheritedlink[@class=$ancestorclass and not (@declaring_interface)]/link/span">
																<tr>
																	<td class="regular">
																		<span class="tablePara"><xsl:copy-of select="."/></span>
																	</td>
																	<td class="regular">
																	<span class="tablePara">
																		<xsl:copy-of select="../descrShort/*"/>
																		<xsl:copy-of select="../mslink"/>
																		</span>
																	</td>
																</tr>
															</xsl:for-each>
														</table>
													</span>
												</xsl:if>
											</xsl:for-each>
											<span class="linkList">
												<xsl:value-of select="$vars//localizable//linkList"/>
												<xsl:call-template name="insertparentlinks">
													<xsl:with-param name="namespace" select="$namespace"/>
													<xsl:with-param name="containername" select="$classname"/>
													<xsl:with-param name="containertype" select="'Class'"/>
												</xsl:call-template>
												<xsl:call-template name="insertmemberlinks">
													<xsl:with-param name="namespace" select="$namespace"/>
													<xsl:with-param name="containername" select="$classname"/>
													<xsl:with-param name="membertype" select="'Event'"/>
												</xsl:call-template>
											</span>
											<xsl:call-template name="footer"/>
										</body>
									</html>
								</xsl:document>
							</xsl:if>
							<!-- END of member list processing -->
						</xsl:if>
						<xsl:call-template name="footer"/>
					</body>
				</html>
			</xsl:document>
		</xsl:if>
		<xsl:apply-templates select="members/property[descendant::api] | members/
method[descendant::api]  | members/event[descendant::api] "/>
	</xsl:template>
	<!-- ######################### Property files ####################### -->
	<xsl:template match="/namespace/class/members/property
                     | /namespace/interface/members/property">
		<xsl:variable name="containername" select="../../@name"/>
		<xsl:variable name="containertype" select="name (../..)"/>
		<xsl:variable name="propstring" select="concat('html/', /namespace/@name, $containername, @name)"/>
		<xsl:variable name="propstripped" select="translate($propstring, '.', '')"/>
		<xsl:variable name="propfile" select="concat('uncleaned_',$propstripped, 'Property.htm')"/>
		<!-- This produces property files -->
		<xsl:document method="xml" indent="yes" href="{$propfile}">
			<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp" DIR="LTR">
				<head>
					<link rel="stylesheet" type="text/css" href="../common/bdshelp.css"/>
					<SCRIPT SRC="../common/linker.js">
						<xsl:text> </xsl:text>
					</SCRIPT>
					<xml>
						<xsl:element name="MSHelp:TOCTitle">
							<xsl:attribute name="Title"><xsl:value-of select="@name"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/Property"/></xsl:attribute>
						</xsl:element>
						<xsl:element name="MSHelp:RLTitle">
							<xsl:attribute name="Title"><xsl:value-of select="@name"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/Property"/></xsl:attribute>
						</xsl:element>
						<!-- call helplinks here -->
						<xsl:variable name="proplinkstring">
							<xsl:value-of select="/namespace/@name"/>.<xsl:value-of select="$containername"/>.<xsl:value-of select="@name"/>
						</xsl:variable>
						<!-- #### calling helplinks #### -->
						<xsl:call-template name="helplinks">
							<xsl:with-param name="linkstring" select="$proplinkstring"/>
						</xsl:call-template>
						<xsl:value-of select="$vars//localizable/helpattributes"/>
					</xml>
					<META HTTP-EQUIV="Content-Type" Content="text/html; charset=Windows-1252"/>
					<basefont size="2"/>
				</head>
				<body>
					<title>
						<xsl:value-of select="../../@name"/>
						<xsl:text>.</xsl:text>
						<xsl:value-of select="@name"/>
						<xsl:text> </xsl:text>
						<xsl:choose>
							<xsl:when test="./syntax/arrayprop">
								<xsl:value-of select="$vars//localizable/arrayproperty"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$vars//localizable/Property"/>
							</xsl:otherwise>
						</xsl:choose>
					</title>
					<span class="title">
						<xsl:value-of select="../../@name"/>
						<xsl:text>.</xsl:text>
						<xsl:value-of select="@name"/>
						<xsl:text> </xsl:text>
						<xsl:choose>
							<xsl:when test="./syntax/arrayprop">
								<xsl:value-of select="$vars//localizable/arrayproperty"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$vars//localizable/Property"/>
							</xsl:otherwise>
						</xsl:choose>
					</span>
					<xsl:for-each select="api/descrShort">
						<span class="para">
							<xsl:apply-templates select="."/>
						</span>
					</xsl:for-each>
					<xsl:if test="$containertype='class'">
						<xsl:call-template name="referencelink">
							<xsl:with-param name="type" select="$vars//localizable/class"/>
							<xsl:with-param name="namespace" select="/namespace/@name"/>
							<xsl:with-param name="value" select="../../@name"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="$containertype='interface'">
						<xsl:call-template name="referencelink">
							<xsl:with-param name="type" select="$vars//localizable/interface"/>
							<xsl:with-param name="namespace" select="/namespace/@name"/>
							<xsl:with-param name="value" select="../../@name"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:call-template name="labelsyntax"/>
					<xsl:call-template name="propsyntax"/>
					<xsl:variable name="longdescription" select="normalize-space(api/descrLong)"/>
					<xsl:if test="string-length (string($longdescription)) > 1">
						<xsl:call-template name="labeldesc"/>
						<xsl:for-each select="api/descrLong">
							<span class="para">
								<xsl:apply-templates select="."/>
							</span>
						</xsl:for-each>
					</xsl:if>
					<xsl:call-template name="footer"/>
				</body>
			</html>
		</xsl:document>
	</xsl:template>
	<!-- ######################### Method files ####################### -->
	<xsl:template match="/namespace/class/members/method
  | /namespace/interface/members/method">
		<xsl:variable name="containername" select="../../@name"/>
		<xsl:variable name="containertype" select="name (../..)"/>
		<xsl:variable name="methname" select="@name"/>
		<xsl:variable name="methstring" select="concat('html/', /namespace/@name, $containername, $methname)"/>
		<xsl:variable name="methstripped" select="translate($methstring, '.', '')"/>
		<xsl:variable name="methfile" select="concat('uncleaned_',$methstripped, 'Method.htm')"/>
		<!-- This produces method files -->
		<xsl:document method="xml" indent="yes" href="{$methfile}">
			<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp" DIR="LTR">
				<head>
					<link rel="stylesheet" type="text/css" href="../common/bdshelp.css"/>
					<SCRIPT SRC="../common/linker.js">
						<xsl:text> </xsl:text>
					</SCRIPT>
					<xml>
						<xsl:element name="MSHelp:TOCTitle">
							<xsl:attribute name="Title"><xsl:value-of select="$methname"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/Method"/></xsl:attribute>
						</xsl:element>
						<xsl:element name="MSHelp:RLTitle">
							<xsl:attribute name="Title"><xsl:value-of select="$methname"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/Method"/></xsl:attribute>
						</xsl:element>
						<!-- call helplinks here -->
						<xsl:variable name="methlinkstring">
							<xsl:value-of select="/namespace/@name"/>.<xsl:value-of select="$containername"/>.<xsl:value-of select="$methname"/>
						</xsl:variable>
						<!-- #### calling helplinks #### -->
						<xsl:call-template name="helplinks">
							<xsl:with-param name="linkstring" select="$methlinkstring"/>
						</xsl:call-template>
						<xsl:value-of select="$vars//localizable/helpattributes"/>
					</xml>
					<META HTTP-EQUIV="Content-Type" Content="text/html; charset=Windows-1252"/>
					<basefont size="2"/>
				</head>
				<body>
					<title>
						<!-- if it is a constructor, label it as such-->
						<xsl:if test="not ($containername = $methname)">
							<xsl:value-of select="$containername"/>
							<xsl:text>.</xsl:text>
						</xsl:if>
						<xsl:value-of select="$methname"/>
						<xsl:text> </xsl:text>
						<xsl:choose>
							<xsl:when test="$containername = $methname or $methname='Create'">
								<xsl:value-of select="$vars//localizable/constructor"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$vars//localizable/Method"/>
							</xsl:otherwise>
						</xsl:choose>
					</title>
					<span class="title">
						<xsl:if test="not ($containername = $methname)">
							<xsl:value-of select="$containername"/>
							<xsl:text>.</xsl:text>
						</xsl:if>
						<xsl:value-of select="$methname"/>
						<xsl:text> </xsl:text>
						<xsl:choose>
							<xsl:when test="$containername = $methname or $methname='Create'">
								<xsl:value-of select="$vars//localizable/constructor"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$vars//localizable/Method"/>
							</xsl:otherwise>
						</xsl:choose>
					</span>
					<xsl:for-each select="api/descrShort">
						<span class="para">
							<xsl:apply-templates select="."/>
						</span>
					</xsl:for-each>
					<xsl:if test="$containertype='class'">
						<xsl:call-template name="referencelink">
							<xsl:with-param name="type" select="$vars//localizable/class"/>
							<xsl:with-param name="namespace" select="/namespace/@name"/>
							<xsl:with-param name="value" select="../../@name"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="$containertype='interface'">
						<xsl:call-template name="referencelink">
							<xsl:with-param name="type" select="$vars//localizable/interface"/>
							<xsl:with-param name="namespace" select="/namespace/@name"/>
							<xsl:with-param name="value" select="../../@name"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:call-template name="labelsyntax"/>
					<span class="list">
						<xsl:for-each select="syntax">
							<p>
								<span class="li">
									<span class="syntax">
										<xsl:call-template name="methodsyntax"/>
									</span>
								</span>
							</p>
						</xsl:for-each>
					</span>
					<xsl:variable name="longdescription" select="normalize-space(api/descrLong)"/>
					<xsl:if test="string-length (string($longdescription)) > 1">
						<xsl:call-template name="labeldesc"/>
						<xsl:for-each select="api/descrLong">
							<span class="para">
								<xsl:apply-templates select="."/>
							</span>
						</xsl:for-each>
					</xsl:if>
					<xsl:call-template name="footer"/>
				</body>
			</html>
		</xsl:document>
	</xsl:template>
	<!-- ######################### Event files ####################### -->
	<xsl:template match="/namespace/class/members/event
                     | /namespace/interface/members/event">
		<xsl:variable name="containername" select="../../@name"/>
		<xsl:variable name="containertype" select="name (../..)"/>
		<xsl:variable name="eventname" select="@name"/>
		<xsl:variable name="eventstring" select="concat('html/', /namespace/@name, $containername, $eventname)"/>
		<xsl:variable name="eventstripped" select="translate($eventstring, '.', '')"/>
		<xsl:variable name="eventfile" select="concat('uncleaned_',$eventstripped, 'Event.htm')"/>
		<!-- This produces event files -->
		<xsl:document method="xml" indent="yes" href="{$eventfile}">
			<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp" DIR="LTR">
				<head>
					<link rel="stylesheet" type="text/css" href="../common/bdshelp.css"/>
					<SCRIPT SRC="../common/linker.js">
						<xsl:text> </xsl:text>
					</SCRIPT>
					<xml>
						<xsl:element name="MSHelp:TOCTitle">
							<xsl:attribute name="Title"><xsl:value-of select="$eventname"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/Event"/></xsl:attribute>
						</xsl:element>
						<xsl:element name="MSHelp:RLTitle">
							<xsl:attribute name="Title"><xsl:value-of select="$eventname"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/Event"/></xsl:attribute>
						</xsl:element>
						<!-- call helplinks here -->
						<xsl:variable name="eventlinkstring">
							<xsl:value-of select="/namespace/@name"/>.<xsl:value-of select="$containername"/>.<xsl:value-of select="$eventname"/>
						</xsl:variable>
						<!-- #### calling helplinks #### -->
						<xsl:call-template name="helplinks">
							<xsl:with-param name="linkstring" select="$eventlinkstring"/>
						</xsl:call-template>
						<xsl:value-of select="$vars//localizable/helpattributes"/>
					</xml>
					<META HTTP-EQUIV="Content-Type" Content="text/html; charset=Windows-1252"/>
					<basefont size="2"/>
				</head>
				<body>
					<title>
						<xsl:value-of select="../../@name"/>
						<xsl:text>.</xsl:text>
						<xsl:value-of select="$eventname"/>
						<xsl:text> </xsl:text>
						<xsl:value-of select="$vars//localizable/Event"/>
					</title>
					<span class="title">
						<xsl:value-of select="../../@name"/>
						<xsl:text>.</xsl:text>
						<xsl:value-of select="$eventname"/>
						<xsl:text> </xsl:text>
						<xsl:value-of select="$vars//localizable/Event"/>
					</span>
					<xsl:for-each select="api/descrShort">
						<span class="para">
							<xsl:apply-templates select="."/>
						</span>
					</xsl:for-each>
					<xsl:if test="$containertype='class'">
						<xsl:call-template name="referencelink">
							<xsl:with-param name="type" select="$vars//localizable/class"/>
							<xsl:with-param name="namespace" select="/namespace/@name"/>
							<xsl:with-param name="value" select="../../@name"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="$containertype='interface'">
						<xsl:call-template name="referencelink">
							<xsl:with-param name="type" select="$vars//localizable/interface"/>
							<xsl:with-param name="namespace" select="/namespace/@name"/>
							<xsl:with-param name="value" select="../../@name"/>
						</xsl:call-template>
					</xsl:if>
					<xsl:call-template name="labelsyntax"/>
					<span class="list">
						<p>
							<span class="li">
								<span class="syntax">
									<xsl:call-template name="eventsyntax"/>
								</span>
							</span>
						</p>
					</span>
					<xsl:variable name="longdescription" select="normalize-space(api/descrLong)"/>
					<xsl:if test="string-length (string($longdescription)) > 1">
						<xsl:call-template name="labeldesc"/>
						<xsl:for-each select="api/descrLong">
							<span class="para">
								<xsl:apply-templates select="."/>
							</span>
						</xsl:for-each>
					</xsl:if>
					<xsl:call-template name="footer"/>
				</body>
			</html>
		</xsl:document>
	</xsl:template>
	<!-- #################### Interface files ###################### -->
	<!-- ########################################################### -->
	<xsl:template match="/namespace/interface">
		<xsl:variable name="interfacename" select="@name"/>
		<xsl:variable name="namespace" select="@namespace"/>
		<!-- ######################### Top level interface files ####################### -->
		<xsl:variable name="interfacestring">
			<xsl:value-of select="concat('html/', $namespace, $interfacename)"/>
		</xsl:variable>
		<xsl:variable name="stripped" select="translate($interfacestring, '.', '')"/>
		<xsl:variable name="interfacefile">
			<xsl:value-of select="concat('uncleaned_',$stripped, 'Interface.htm')"/>
		</xsl:variable>
		<xsl:document method="xml" indent="yes" href="{$interfacefile}">
			<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp" DIR="LTR">
				<head>
					<link rel="stylesheet" type="text/css" href="../common/bdshelp.css"/>
					<SCRIPT SRC="../common/linker.js">
						<xsl:text> </xsl:text>
					</SCRIPT>
					<xml>
						<xsl:element name="MSHelp:TOCTitle">
							<xsl:attribute name="Title"><xsl:value-of select="$interfacename"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/interface"/></xsl:attribute>
						</xsl:element>
						<xsl:element name="MSHelp:RLTitle">
							<xsl:attribute name="Title"><xsl:value-of select="$interfacename"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/interface"/></xsl:attribute>
						</xsl:element>
						<!-- call helplinks here -->
						<xsl:variable name="interfacelinkstring">
							<xsl:value-of select="$namespace"/>.<xsl:value-of select="$interfacename"/>
						</xsl:variable>
						<!-- #### calling helplinks #### -->
						<xsl:call-template name="helplinks">
							<xsl:with-param name="linkstring" select="$interfacelinkstring"/>
						</xsl:call-template>
						<xsl:value-of select="$vars//localizable/helpattributes"/>
					</xml>
					<META HTTP-EQUIV="Content-Type" Content="text/html; charset=Windows-1252"/>
					<basefont size="2"/>
				</head>
				<!--############################ content block for interface files ####################-->
				<body>
					<title>
						<xsl:value-of select="$interfacename"/>
					</title>
					<span class="title">
						<xsl:value-of select="$interfacename"/>
						<xsl:text> </xsl:text>
						<xsl:value-of select="$vars//localizable/interface"/>
					</span>
					<!-- #### descrShort ####-->
					<xsl:for-each select="api/descrShort">
						<xsl:apply-templates select="."/>
					</xsl:for-each>
					<xsl:call-template name="referencelink">
						<xsl:with-param name="type" select="$vars//localizable/namespace"/>
						<xsl:with-param name="namespace" select="$namespace"/>
						<xsl:with-param name="value" select="$namespace"/>
					</xsl:call-template>
					<xsl:call-template name="labelsyntax"/>
					<span class="list">
						<p>
							<span class="li">
								<span class="syntax">
									<xsl:call-template name="containersyntax">
										<xsl:with-param name="type">interface</xsl:with-param>
									</xsl:call-template>
								</span>
							</span>
						</p>
					</span>
					<!-- #### descrLong #### -->
					<xsl:variable name="longdescription" select="normalize-space(api/descrLong)"/>
					<xsl:if test="string-length (string($longdescription)) > 1">
						<xsl:call-template name="labeldesc"/>
						<xsl:for-each select="api/descrLong">
							<span class="descrLong">
								<xsl:apply-templates select="."/>
							</span>
						</xsl:for-each>
					</xsl:if>
					<!-- #### Implemented Interfaces #### -->
					<xsl:variable name="interfaceimplementslinknode">
						<xsl:for-each select="interfaces">
							<xsl:for-each select="implements">
								<span class="listedLink">
									<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
									<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
										<xsl:attribute name="keywords"><xsl:value-of select="@name"/></xsl:attribute>
										<xsl:value-of select="@name"/>
										<xsl:if test="starts-with(@name, 'System.')">
											<xsl:call-template name="msicon"/>
										</xsl:if>
									</MSHelp:link>
								</span>
							</xsl:for-each>
						</xsl:for-each>
					</xsl:variable>
					<!-- leave out the heading if there are no implemented interfaces. -->
					<xsl:if test="boolean($interfaceimplementslinknode//MSHelp:link)">
						<!-- #### this sorts the 2 types of links above #### -->
						<span class="linkList">
							<xsl:value-of select="$vars//localizable/interfaces"/>
							<xsl:for-each select="$interfaceimplementslinknode/span">
								<xsl:sort select="MSHelp:link/text()"/>
								<xsl:copy-of select="."/>
							</xsl:for-each>
						</span>
					</xsl:if>
					<!-- make a new file for all members -->
					<xsl:if test="members/property | members/method | members/event 
                                                      | propertylinks/propertylink | methodlinks/methodlink 
                                                      | eventlinks/eventlink">
						<span class="linkList">
							<xsl:value-of select="$vars//localizable//linkList"/>
							<xsl:call-template name="insertmemberlinks">
								<xsl:with-param name="namespace" select="$namespace"/>
								<xsl:with-param name="containername" select="$interfacename"/>
								<xsl:with-param name="membertype" select="'All'"/>
							</xsl:call-template>
						</span>
						<xsl:call-template name="makemembersfile">
							<xsl:with-param name="namespace" select="$namespace"/>
							<xsl:with-param name="containername" select="$interfacename"/>
							<xsl:with-param name="containertype" select="$vars//localizable/interface"/>
							<xsl:with-param name="stripped" select="$stripped"/>
						</xsl:call-template>
						<xsl:if test="members/property | propertylinks/propertylink">
							<!-- ##################### PROPERTIES FILE ###################### -->
							<xsl:variable name="propertiesfile">
								<xsl:value-of select="concat('uncleaned_',$stripped, 'Properties.htm')"/>
							</xsl:variable>
							<xsl:document method="xml" indent="yes" href="{$propertiesfile}">
								<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp" DIR="LTR">
									<head>
										<link rel="stylesheet" type="text/css" href="../common/bdshelp.css"/>
										<SCRIPT SRC="../common/linker.js">
											<xsl:text> </xsl:text>
										</SCRIPT>
										<xml>
											<xsl:element name="MSHelp:TOCTitle">
												<xsl:attribute name="Title"><xsl:value-of select="$interfacename"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/properties"/></xsl:attribute>
											</xsl:element>
											<xsl:element name="MSHelp:RLTitle">
												<xsl:attribute name="Title"><xsl:value-of select="$interfacename"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/properties"/></xsl:attribute>
											</xsl:element>
											<xsl:variable name="linkstring">
												<xsl:value-of select="$namespace"/>.<xsl:value-of select="$interfacename"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="$vars//localizable/properties"/>
											</xsl:variable>
											<!-- #### calling helplinks #### -->
											<xsl:call-template name="helplinks">
												<xsl:with-param name="linkstring" select="$linkstring"/>
											</xsl:call-template>
											<xsl:value-of select="$vars//localizable/helpattributes"/>
										</xml>
										<META HTTP-EQUIV="Content-Type" Content="text/html; charset=Windows-1252"/>
										<basefont size="2"/>
									</head>
									<!--####### content block for interface files #########-->
									<body>
										<title>
											<xsl:value-of select="$interfacename"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="$vars//localizable/properties"/>
										</title>
										<span class="title">
											<xsl:value-of select="$interfacename"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="$vars//localizable/properties"/>
										</span>
										<!-- ########## propertylinks ########## -->
										<!-- collecting in a variable so they can all be sorted-->
										<xsl:variable name="proplinknode">
											<!-- ########## property links ######### -->
											<xsl:for-each select="propertylinks/propertylink[not(property=following-sibling::propertylink/property) and not(../../members/property/@name=property)]">
												<xsl:variable name="proplinkname" select="property/text()"/>
												<xsl:if test="not(../../members/property[@name=$proplinkname])">
													<xsl:element name="inheritedlink">
														<xsl:copy-of select="@declaring_interface"/>
														<xsl:attribute name="namespace"><xsl:value-of select="namespace"/></xsl:attribute>
														<xsl:attribute name="interface"><xsl:value-of select="interface"/></xsl:attribute>
														<xsl:if test="@docset='microsoft'">
															<link>
																<span class="link">
																	<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																	<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																		<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="property"/></xsl:attribute>
																		<xsl:value-of select="property"/>
																		<xsl:if test="boolean(@declaring_interface)">
																			<span class="pt">
																				<xsl:text> (</xsl:text>
																				<xsl:value-of select="@declaring_interface"/>
																				<xsl:text>)</xsl:text>
																			</span>
																		</xsl:if>
																	</MSHelp:link>
																</span>
																<mslink>
																	<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																	<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																		<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="property"/></xsl:attribute>
																		<xsl:value-of select="$vars//localizable/Inheritedfrom"/>
																		<xsl:text> </xsl:text>
																		<xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>
																		<xsl:call-template name="msicon"/>
																	</MSHelp:link>
																</mslink>
																<xsl:copy-of select="descrShort"/>
															</link>
														</xsl:if>
														<xsl:if test="@docset='borland'">
															<link>
																<span class="link">
																	<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																	<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																		<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="property"/></xsl:attribute>
																		<xsl:value-of select="property"/>
																		<xsl:if test="boolean(@declaring_interface)">
																			<span class="pt">
																				<xsl:text> (</xsl:text>
																				<xsl:value-of select="@declaring_interface"/>
																				<xsl:text>)</xsl:text>
																			</span>
																		</xsl:if>
																	</MSHelp:link>
																</span>
																<xsl:copy-of select="descrShort"/>
															</link>
														</xsl:if>
													</xsl:element>
												</xsl:if>
											</xsl:for-each>
											<!-- ########## member properties ########-->
											<!-- avoids repeating indexers which are "overloaded" -->
											<xsl:for-each select="members/property[not(@name=following-sibling::property/@name)]">
												<link>
													<span class="link">
														<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
														<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
															<xsl:attribute name="keywords"><xsl:value-of select="$namespace"/>.<xsl:value-of select="$interfacename"/>.<xsl:value-of select="@name"/></xsl:attribute>
															<xsl:value-of select="@name"/>
															<xsl:if test="boolean(@declaring_interface)">
																<span class="pt">
																	<xsl:text> (</xsl:text>
																	<xsl:value-of select="@declaring_interface"/>
																	<xsl:text>)</xsl:text>
																</span>
															</xsl:if>
														</MSHelp:link>
													</span>
													<xsl:copy-of select="./api/descrShort"/>
												</link>
											</xsl:for-each>
										</xsl:variable>
										<!-- locally-documented properties -->
										<xsl:if test="boolean($proplinknode/link/span/MSHelp:link | $proplinknode/inheritedlink[@declaring_interface]/link/span/MSHelp:link)">
											<span class="linkList">
												<xsl:value-of select="$vars//localizable/Propertiesof"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="$interfacename"/>
												<table class="regular">
													<xsl:for-each select="$proplinknode/link/span | $proplinknode/inheritedlink[@declaring_interface]/link/span">
														<xsl:sort select="MSHelp:link/text()"/>
														<tr>
															<td class="regular">
																<span class="tablePara"><xsl:copy-of select="."/></span>
															</td>
															<td class="regular">
															<span class="tablePara">
																<xsl:copy-of select="../descrShort/*"/>
																<xsl:copy-of select="../mslink"/>
																</span>
															</td>
														</tr>
													</xsl:for-each>
												</table>
											</span>
										</xsl:if>
										<!-- inherited properties -->
										<xsl:for-each select="hierarchy/ancestor">
											<xsl:variable name="ancestorclass">
												<xsl:value-of select="class"/>
											</xsl:variable>
											<xsl:if test="$proplinknode/inheritedlink[@class=$ancestorclass and not (@declaring_interface)]">
												<span class="linkList">
													<xsl:value-of select="$vars//localizable/propertiesinheritedfrom"/>
													<xsl:text> </xsl:text>
													<xsl:value-of select="concat(namespace,'.',class)"/>
													<table class="regular">
														<xsl:for-each select="$proplinknode/inheritedlink[@class=$ancestorclass and not (@declaring_interface)]/link/span">
															<xsl:sort select="MSHelp:link/text()"/>
															<tr>
																<td class="regular">
																	<span class="tablePara"><xsl:copy-of select="."/></span>
																</td>
																<td class="regular">
																<span class="tablePara">
																	<xsl:copy-of select="../descrShort/*"/>
																	<xsl:copy-of select="../mslink"/>
																	</span>
																</td>
															</tr>
														</xsl:for-each>
													</table>
												</span>
											</xsl:if>
										</xsl:for-each>
										<span class="linkList">
											<xsl:value-of select="$vars//localizable//linkList"/>
											<xsl:call-template name="insertparentlinks">
												<xsl:with-param name="namespace" select="$namespace"/>
												<xsl:with-param name="containername" select="$interfacename"/>
												<xsl:with-param name="containertype" select=" 'Interface'"/>
											</xsl:call-template>
											<xsl:call-template name="insertmemberlinks">
												<xsl:with-param name="namespace" select="$namespace"/>
												<xsl:with-param name="containername" select="$interfacename"/>
												<xsl:with-param name="membertype" select="'Property'"/>
											</xsl:call-template>
										</span>
										<xsl:call-template name="footer"/>
									</body>
								</html>
							</xsl:document>
						</xsl:if>
						<xsl:if test="members/method | methodlinks/methodlink">
							<!-- ##################### METHODS FILE ###################### -->
							<xsl:variable name="methodsfile">
								<xsl:value-of select="concat('uncleaned_',$stripped, 'Methods.htm')"/>
							</xsl:variable>
							<xsl:document method="xml" indent="yes" href="{$methodsfile}">
								<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp" DIR="LTR">
									<head>
										<link rel="stylesheet" type="text/css" href="../common/bdshelp.css"/>
										<SCRIPT SRC="../common/linker.js">
											<xsl:text> </xsl:text>
										</SCRIPT>
										<xml>
											<xsl:element name="MSHelp:TOCTitle">
												<xsl:attribute name="Title"><xsl:value-of select="$interfacename"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/methods"/></xsl:attribute>
											</xsl:element>
											<xsl:element name="MSHelp:RLTitle">
												<xsl:attribute name="Title"><xsl:value-of select="$interfacename"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/methods"/></xsl:attribute>
											</xsl:element>
											<xsl:variable name="linkstring">
												<xsl:value-of select="$namespace"/>.<xsl:value-of select="$interfacename"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="$vars//localizable/methods"/>
											</xsl:variable>
											<!-- #### calling helplinks #### -->
											<xsl:call-template name="helplinks">
												<xsl:with-param name="linkstring" select="$linkstring"/>
											</xsl:call-template>
											<xsl:value-of select="$vars//localizable/helpattributes"/>
										</xml>
										<META HTTP-EQUIV="Content-Type" Content="text/html; charset=Windows-1252"/>
										<basefont size="2"/>
									</head>
									<!--####### content block for class files #########-->
									<body>
										<title>
											<xsl:value-of select="$interfacename"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="$vars//localizable/methods"/>
										</title>
										<span class="title">
											<xsl:value-of select="$interfacename"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="$vars//localizable/methods"/>
										</span>
										<!-- ########## methodlinks ########## -->
										<!-- collecting in a variable so they can all be sorted-->
										<xsl:variable name="methodlinknode">
											<!-- ########## method links ######### -->
											<xsl:for-each select="methodlinks/methodlink[not(method=following-sibling::methodlink/method) and not(../../members/method/@name=method)]">
												<xsl:variable name="methlinkname" select="method/text()"/>
												<xsl:if test="not(../../members/method[@name=$methlinkname])">
													<xsl:element name="inheritedlink">
														<xsl:copy-of select="@declaring_interface"/>
														<xsl:attribute name="namespace"><xsl:value-of select="namespace"/></xsl:attribute>
														<xsl:attribute name="interface"><xsl:value-of select="interface"/></xsl:attribute>
														<xsl:if test="@docset='microsoft'">
															<link>
																<span class="link">
																	<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																	<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																		<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="method"/></xsl:attribute>
																		<xsl:value-of select="method"/>
																		<xsl:if test="count(syntax)&gt;1">
																			<span class="pt">
																				<xsl:text> (</xsl:text>
																				<xsl:value-of select="$vars//localizable/overloaded"/>
																				<xsl:text>)</xsl:text>
																			</span>
																		</xsl:if>
																		<xsl:if test="boolean(@declaring_interface)">
																			<span class="pt">
																				<xsl:text> (</xsl:text>
																				<xsl:value-of select="@declaring_interface"/>
																				<xsl:text>)</xsl:text>
																			</span>
																		</xsl:if>
																	</MSHelp:link>
																</span>
																<mslink>
																	<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																	<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																		<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="method"/></xsl:attribute>
																		<xsl:apply-templates select="$vars//localizable/Inheritedfrom/node()">
																			<xsl:with-param name="membername">
																				<xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>
																			</xsl:with-param>
																		</xsl:apply-templates>
																		<xsl:call-template name="msicon"/>
																	</MSHelp:link>
																</mslink>
																<xsl:copy-of select="descrShort"/>
															</link>
														</xsl:if>
														<xsl:if test="@docset='borland'">
															<link>
																<span class="link">
																	<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																	<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																		<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="method"/></xsl:attribute>
																		<xsl:value-of select="method"/>
																		<xsl:if test="count(syntax)&gt;1">
																			<span class="pt">
																				<xsl:text> (</xsl:text>
																				<xsl:value-of select="$vars//localizable/overloaded"/>
																				<xsl:text>)</xsl:text>
																			</span>
																		</xsl:if>
																		<xsl:if test="boolean(@declaring_interface)">
																			<span class="pt">
																				<xsl:text> (</xsl:text>
																				<xsl:value-of select="@declaring_interface"/>
																				<xsl:text>)</xsl:text>
																			</span>
																		</xsl:if>
																	</MSHelp:link>
																</span>
																<xsl:copy-of select="descrShort"/>
															</link>
														</xsl:if>
													</xsl:element>
												</xsl:if>
											</xsl:for-each>
											<!-- ########## member methods ########-->
											<!-- avoids repeating indexers which are "overloaded" -->
											<xsl:for-each select="members/method[not(@name=following-sibling::method/@name)]">
												<link>
													<span class="link">
														<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
														<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
															<xsl:attribute name="keywords"><xsl:value-of select="$namespace"/>.<xsl:value-of select="$interfacename"/>.<xsl:value-of select="@name"/></xsl:attribute>
															<xsl:value-of select="@name"/>
															<xsl:if test="boolean(@declaring_interface)">
																<span class="pt">
																	<xsl:text> (</xsl:text>
																	<xsl:value-of select="@declaring_interface"/>
																	<xsl:text>)</xsl:text>
																</span>
															</xsl:if>
														</MSHelp:link>
													</span>
													<xsl:copy-of select="./api/descrShort"/>
												</link>
											</xsl:for-each>
										</xsl:variable>
										<!-- locally-documented methods -->
										<xsl:if test="boolean($methodlinknode/link/span/MSHelp:link | $methodlinknode/inheritedlink[@declaring_interface]/link/span/MSHelp:link)">
											<span class="linkList">
												<xsl:value-of select="$vars//localizable/Methodsof"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="$interfacename"/>
												<table class="regular">
													<xsl:for-each select="$methodlinknode/link/span | $methodlinknode/inheritedlink[@declaring_interface]/link/span">
														<xsl:sort select="MSHelp:link/text()"/>
														<tr>
															<td class="regular">
																<span class="tablePara"><xsl:copy-of select="."/></span>
															</td>
															<td class="regular">
															<span class="tablePara">
																<xsl:copy-of select="../descrShort/*"/>
																<xsl:copy-of select="../mslink"/>
																</span>
															</td>
														</tr>
													</xsl:for-each>
												</table>
											</span>
										</xsl:if>
										<!-- inherited methods -->
										<xsl:for-each select="hierarchy/ancestor">
											<xsl:variable name="ancestorclass">
												<xsl:value-of select="class"/>
											</xsl:variable>
											<xsl:if test="$methodlinknode/inheritedlink[@class=$ancestorclass and not (@declaring_interface)]">
												<span class="linkList">
													<xsl:value-of select="$vars//localizable/methodsinheritedfrom"/>
													<xsl:text> </xsl:text>
													<xsl:value-of select="concat(namespace,'.',class)"/>
													<table class="regular">
														<xsl:for-each select="$methodlinknode/inheritedlink[@class=$ancestorclass and not (@declaring_interface)]/link/span">
															<xsl:sort select="MSHelp:link/text()"/>
															<tr>
																<td class="regular">
																	<span class="tablePara"><xsl:copy-of select="."/></span>
																</td>
																<td class="regular">
																<span class="tablePara">
																	<xsl:copy-of select="../descrShort/*"/>
																	<xsl:copy-of select="../mslink"/>
																	</span>
																</td>
															</tr>
														</xsl:for-each>
													</table>
												</span>
											</xsl:if>
										</xsl:for-each>
										<span class="linkList">
											<xsl:value-of select="$vars//localizable//linkList"/>
											<xsl:call-template name="insertparentlinks">
												<xsl:with-param name="namespace" select="$namespace"/>
												<xsl:with-param name="containername" select="$interfacename"/>
												<xsl:with-param name="containertype" select="'Interface'"/>
											</xsl:call-template>
											<xsl:call-template name="insertmemberlinks">
												<xsl:with-param name="namespace" select="$namespace"/>
												<xsl:with-param name="containername" select="$interfacename"/>
												<xsl:with-param name="membertype" select="'Method'"/>
											</xsl:call-template>
										</span>
										<xsl:call-template name="footer"/>
									</body>
								</html>
							</xsl:document>
						</xsl:if>
						<xsl:if test="members/event | eventlinks/eventlink">
							<!-- ##################### EVENTS FILE ###################### -->
							<xsl:variable name="eventsfile">
								<xsl:value-of select="concat('uncleaned_',$stripped, 'Events.htm')"/>
							</xsl:variable>
							<xsl:document method="xml" indent="yes" href="{$eventsfile}">
								<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp" DIR="LTR">
									<head>
										<link rel="stylesheet" type="text/css" href="../common/bdshelp.css"/>
										<SCRIPT SRC="../common/linker.js">
											<xsl:text> </xsl:text>
										</SCRIPT>
										<xml>
											<xsl:element name="MSHelp:TOCTitle">
												<xsl:attribute name="Title"><xsl:value-of select="$interfacename"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/events"/></xsl:attribute>
											</xsl:element>
											<xsl:element name="MSHelp:RLTitle">
												<xsl:attribute name="Title"><xsl:value-of select="$interfacename"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/events"/></xsl:attribute>
											</xsl:element>
											<xsl:variable name="linkstring">
												<xsl:value-of select="$namespace"/>.<xsl:value-of select="$interfacename"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="$vars//localizable/events"/>
											</xsl:variable>
											<!-- #### calling helplinks #### -->
											<xsl:call-template name="helplinks">
												<xsl:with-param name="linkstring" select="$linkstring"/>
											</xsl:call-template>
											<xsl:value-of select="$vars//localizable/helpattributes"/>
										</xml>
										<META HTTP-EQUIV="Content-Type" Content="text/html; charset=Windows-1252"/>
										<basefont size="2"/>
									</head>
									<!--####### content block for interface files #########-->
									<body>
										<title>
											<xsl:value-of select="$interfacename"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="$vars//localizable/events"/>
										</title>
										<span class="title">
											<xsl:value-of select="$interfacename"/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="$vars//localizable/events"/>
										</span>
										<!-- ########## eventlinks ########## -->
										<xsl:variable name="eventlinknode">
											<!-- ########## event links ######### -->
											<xsl:for-each select="eventlinks/eventlink[not(event=following-sibling::eventlink/event) and not(../../members/event/@name=event)]">
												<xsl:variable name="eventlinkname" select="event/text()"/>
												<xsl:if test="not(../../members/event[@name=$eventlinkname])">
													<xsl:element name="inheritedlink">
														<xsl:copy-of select="@declaring_interface"/>
														<xsl:attribute name="namespace"><xsl:value-of select="namespace"/></xsl:attribute>
														<xsl:attribute name="interface"><xsl:value-of select="interface"/></xsl:attribute>
														<xsl:if test="@docset='microsoft'">
															<link>
																<span class="link">
																	<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																	<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																		<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="event"/></xsl:attribute>
																		<xsl:value-of select="event"/>
																		<xsl:if test="boolean(@declaring_interface)">
																			<span class="pt">
																				<xsl:text> (</xsl:text>
																				<xsl:value-of select="@declaring_interface"/>
																				<xsl:text>)</xsl:text>
																			</span>
																		</xsl:if>
																	</MSHelp:link>
																</span>
																<mslink>
																	<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																	<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																		<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="event"/></xsl:attribute>
																		<xsl:apply-templates select="$vars//localizable/Inheritedfrom/node()">
																			<xsl:with-param name="membername">
																				<xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>
																			</xsl:with-param>
																		</xsl:apply-templates>
																		<xsl:call-template name="msicon"/>
																	</MSHelp:link>
																</mslink>
																<xsl:copy-of select="descrShort"/>
															</link>
														</xsl:if>
														<xsl:if test="@docset='borland'">
															<link>
																<span class="link">
																	<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
																	<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
																		<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="event"/></xsl:attribute>
																		<xsl:value-of select="event"/>
																		<xsl:if test="boolean(@declaring_interface)">
																			<span class="pt">
																				<xsl:text> (</xsl:text>
																				<xsl:value-of select="@declaring_interface"/>
																				<xsl:text>)</xsl:text>
																			</span>
																		</xsl:if>
																	</MSHelp:link>
																</span>
																<xsl:copy-of select="descrShort"/>
															</link>
														</xsl:if>
													</xsl:element>
												</xsl:if>
											</xsl:for-each>
											<!-- ########## member events ########-->
											<!--avoids repeating indexers which are "overloaded" -->
											<xsl:for-each select="members/event[not(@name=following-sibling::event/@name)]">
												<link>
													<span class="link">
														<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
														<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
															<xsl:attribute name="keywords"><xsl:value-of select="$namespace"/>.<xsl:value-of select="$interfacename"/>.<xsl:value-of select="@name"/></xsl:attribute>
															<xsl:value-of select="@name"/>
															<xsl:if test="boolean(@declaring_interface)">
																<span class="pt">
																	<xsl:text> (</xsl:text>
																	<xsl:value-of select="@declaring_interface"/>
																	<xsl:text>)</xsl:text>
																</span>
															</xsl:if>
														</MSHelp:link>
													</span>
													<xsl:copy-of select="./api/descrShort"/>
												</link>
											</xsl:for-each>
										</xsl:variable>
										<!-- locally-documented events -->
										<xsl:if test="boolean($eventlinknode/link/span/MSHelp:link | $eventlinknode/inheritedlink[@declaring_interface]/link/span/MSHelp:link)">
											<span class="linkList">
												<xsl:value-of select="$vars//localizable/Eventsof"/>
												<xsl:text> </xsl:text>
												<xsl:value-of select="$interfacename"/>
												<table class="regular">
													<xsl:for-each select="$eventlinknode/link/span | $eventlinknode/inheritedlink[@declaring_interface]/link/span">
														<xsl:sort select="MSHelp:link/text()"/>
														<tr>
															<td class="regular">
																<span class="tablePara"><xsl:copy-of select="."/></span>
															</td>
															<td class="regular">
															<span class="tablePara">
																<xsl:copy-of select="../descrShort/*"/>
																<xsl:copy-of select="../mslink"/>
																</span>
															</td>
														</tr>
													</xsl:for-each>
												</table>
											</span>
										</xsl:if>
										<!-- inherited events -->
										<xsl:for-each select="hierarchy/ancestor">
											<xsl:variable name="ancestorclass">
												<xsl:value-of select="class"/>
											</xsl:variable>
											<xsl:if test="$eventlinknode/inheritedlink[@class=$ancestorclass and not (@declaring_interface)]">
												<span class="linkList">
													<xsl:value-of select="$vars//localizable/eventsinheritedfrom"/>
													<xsl:text> </xsl:text>
													<xsl:value-of select="concat(namespace,'.',class)"/>
													<table class="regular">
														<xsl:for-each select="$eventlinknode/inheritedlink[@class=$ancestorclass and not (@declaring_interface)]/link/span">
															<tr>
																<td class="regular">
																	<span class="tablePara"><xsl:copy-of select="."/></span>
																</td>
																<td class="regular">
																<span class="tablePara">
																	<xsl:copy-of select="../descrShort/*"/>
																	<xsl:copy-of select="../mslink"/>
																	</span>
																</td>
															</tr>
														</xsl:for-each>
													</table>
												</span>
											</xsl:if>
										</xsl:for-each>
										<span class="linkList">
											<xsl:value-of select="$vars//localizable//linkList"/>
											<xsl:call-template name="insertparentlinks">
												<xsl:with-param name="namespace" select="$namespace"/>
												<xsl:with-param name="containername" select="$interfacename"/>
												<xsl:with-param name="containertype" select="'Interface'"/>
											</xsl:call-template>
											<xsl:call-template name="insertmemberlinks">
												<xsl:with-param name="namespace" select="$namespace"/>
												<xsl:with-param name="containername" select="$interfacename"/>
												<xsl:with-param name="membertype" select="'Event'"/>
											</xsl:call-template>
										</span>
										<xsl:call-template name="footer"/>
									</body>
								</html>
							</xsl:document>
						</xsl:if>
						<!-- END of member list processing -->
					</xsl:if>
					<!-- END of member list processing -->
					<xsl:call-template name="footer"/>
				</body>
			</html>
		</xsl:document>
		<xsl:apply-templates select="members/property | members/method | members/event"/>
	</xsl:template>
	<!-- ####################### type files  ######################## -->
	<!-- ############################################################ -->
	<xsl:template match="/namespace/type">
		<xsl:variable name="typename" select="@name"/>
		<xsl:variable name="namespace" select="/namespace/@name"/>
		<xsl:variable name="typestring">
			<xsl:value-of select="concat('html/', $namespace, $typename)"/>
		</xsl:variable>
		<xsl:variable name="stripped" select="translate($typestring, '.', '')"/>
		<xsl:variable name="typefile">
			<xsl:value-of select="concat('uncleaned_',$stripped, 'Type.htm')"/>
		</xsl:variable>
		<xsl:variable name="titlevariety">
			<xsl:call-template name="varietytotitle">
				<xsl:with-param name="variety" select="@variety"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:document method="xml" indent="yes" href="{$typefile}">
			<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp" DIR="LTR">
				<head>
					<link rel="stylesheet" type="text/css" href="../common/bdshelp.css"/>
					<SCRIPT SRC="../common/linker.js">
						<xsl:text> </xsl:text>
					</SCRIPT>
					<xml>
						<xsl:element name="MSHelp:TOCTitle">
							<xsl:attribute name="Title"><xsl:value-of select="$typename"/><xsl:text> </xsl:text><xsl:value-of select="$titlevariety"/></xsl:attribute>
						</xsl:element>
						<xsl:element name="MSHelp:RLTitle">
							<xsl:attribute name="Title"><xsl:value-of select="$typename"/><xsl:text> </xsl:text><xsl:value-of select="$titlevariety"/></xsl:attribute>
						</xsl:element>
						<!-- call helplinks here -->
						<xsl:variable name="typelinkstring">
							<xsl:value-of select="$namespace"/>.<xsl:value-of select="$typename"/>
						</xsl:variable>
						<!-- #### calling helplinks #### -->
						<xsl:call-template name="helplinks">
							<xsl:with-param name="linkstring" select="$typelinkstring"/>
						</xsl:call-template>
						<xsl:value-of select="$vars//localizable/helpattributes"/>
					</xml>
					<META HTTP-EQUIV="Content-Type" Content="text/html; charset=Windows-1252"/>
					<basefont size="2"/>
				</head>
				<!--############################ content block for type files ####################-->
				<body>
					<title>
						<xsl:value-of select="$typename"/>
					</title>
					<span class="title">
						<xsl:value-of select="$typename"/>
						<xsl:text> </xsl:text>
						<xsl:value-of select="$titlevariety"/>
					</span>
					<!-- #### descrShort ####-->
					<xsl:for-each select="api/descrShort">
						<xsl:apply-templates select="."/>
					</xsl:for-each>
					<xsl:call-template name="referencelink">
						<xsl:with-param name="type" select="$vars//localizable/namespace"/>
						<xsl:with-param name="namespace" select="$namespace"/>
						<xsl:with-param name="value" select="$namespace"/>
					</xsl:call-template>
					<xsl:call-template name="labelsyntax"/>
					<span class="list">
						<p>
							<span class="li">
								<span class="syntax">
									<xsl:call-template name="containersyntax">
										<xsl:with-param name="type">type</xsl:with-param>
									</xsl:call-template>
								</span>
							</span>
						</p>
					</span>
					<!-- #### descrLong #### -->
					<xsl:variable name="longdescription" select="normalize-space(api/descrLong)"/>
					<xsl:if test="string-length (string($longdescription)) > 1">
						<xsl:call-template name="labeldesc"/>
						<xsl:for-each select="api/descrLong">
							<span class="descrLong">
								<xsl:apply-templates select="."/>
							</span>
						</xsl:for-each>
					</xsl:if>
					<xsl:call-template name="footer"/>
				</body>
			</html>
		</xsl:document>
	</xsl:template>
	<!-- ####################### variable files  ######################## -->
	<!-- ############################################################ -->
	<xsl:template match="/namespace/variable">
		<xsl:variable name="variablename" select="@name"/>
		<xsl:variable name="namespace" select="/namespace/@name"/>
		<xsl:variable name="variablestring">
			<xsl:value-of select="concat('html/', $namespace, $variablename)"/>
		</xsl:variable>
		<xsl:variable name="stripped" select="translate($variablestring, '.', '')"/>
		<xsl:variable name="variablefile">
			<xsl:value-of select="concat('uncleaned_',$stripped, 'Variable.htm')"/>
		</xsl:variable>
		<xsl:document method="xml" indent="yes" href="{$variablefile}">
			<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp" DIR="LTR">
				<head>
					<link rel="stylesheet" type="text/css" href="../common/bdshelp.css"/>
					<SCRIPT SRC="../common/linker.js">
						<xsl:text> </xsl:text>
					</SCRIPT>
					<xml>
						<xsl:element name="MSHelp:TOCTitle">
							<xsl:attribute name="Title"><xsl:value-of select="$variablename"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/variable"/></xsl:attribute>
						</xsl:element>
						<xsl:element name="MSHelp:RLTitle">
							<xsl:attribute name="Title"><xsl:value-of select="$variablename"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/variable"/></xsl:attribute>
						</xsl:element>
						<!-- call helplinks here -->
						<xsl:variable name="variablelinkstring">
							<xsl:value-of select="$namespace"/>.<xsl:value-of select="$variablename"/>
						</xsl:variable>
						<!-- #### calling helplinks #### -->
						<xsl:call-template name="helplinks">
							<xsl:with-param name="linkstring" select="$variablelinkstring"/>
						</xsl:call-template>
						<xsl:value-of select="$vars//localizable/helpattributes"/>
					</xml>
					<META HTTP-EQUIV="Content-Type" Content="text/html; charset=Windows-1252"/>
					<basefont size="2"/>
				</head>
				<!--############################ content block for type files ####################-->
				<body>
					<title>
						<xsl:value-of select="$variablename"/>
					</title>
					<span class="title">
						<xsl:value-of select="$variablename"/>
						<xsl:text> </xsl:text>
						<xsl:value-of select="$vars//localizable/variable"/>
					</span>
					<!-- #### descrShort ####-->
					<xsl:for-each select="api/descrShort">
						<xsl:apply-templates select="."/>
					</xsl:for-each>
					<xsl:call-template name="referencelink">
						<xsl:with-param name="type" select="$vars//localizable/namespace"/>
						<xsl:with-param name="namespace" select="$namespace"/>
						<xsl:with-param name="value" select="$namespace"/>
					</xsl:call-template>
					<xsl:call-template name="labelsyntax"/>
					<span class="list">
						<p>
							<span class="li">
								<span class="syntax">
									<xsl:call-template name="constvarsyntax">
										<xsl:with-param name="type">variable</xsl:with-param>
									</xsl:call-template>
								</span>
							</span>
						</p>
					</span>
					<!-- #### descrLong #### -->
					<xsl:variable name="longdescription" select="normalize-space(api/descrLong)"/>
					<xsl:if test="string-length (string($longdescription)) > 1">
						<xsl:call-template name="labeldesc"/>
						<xsl:for-each select="api/descrLong">
							<span class="descrLong">
								<xsl:apply-templates select="."/>
							</span>
						</xsl:for-each>
					</xsl:if>
					<xsl:call-template name="footer"/>
				</body>
			</html>
		</xsl:document>
	</xsl:template>
	<!-- ####################### constant files  ######################## -->
	<!-- ############################################################ -->
	<xsl:template match="/namespace/constant | /namespace/const">
		<xsl:variable name="constantname" select="@name"/>
		<xsl:variable name="namespace" select="/namespace/@name"/>
		<xsl:variable name="constantstring">
			<xsl:value-of select="concat('html/', $namespace, $constantname)"/>
		</xsl:variable>
		<xsl:variable name="stripped" select="translate($constantstring, '.', '')"/>
		<xsl:variable name="constantfile">
			<xsl:value-of select="concat('uncleaned_',$stripped, 'Constant.htm')"/>
		</xsl:variable>
		<xsl:document method="xml" indent="yes" href="{$constantfile}">
			<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp" DIR="LTR">
				<head>
					<link rel="stylesheet" type="text/css" href="../common/bdshelp.css"/>
					<SCRIPT SRC="../common/linker.js">
						<xsl:text> </xsl:text>
					</SCRIPT>
					<xml>
						<xsl:element name="MSHelp:TOCTitle">
							<xsl:attribute name="Title"><xsl:value-of select="$constantname"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/constant"/></xsl:attribute>
						</xsl:element>
						<xsl:element name="MSHelp:RLTitle">
							<xsl:attribute name="Title"><xsl:value-of select="$constantname"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/constant"/></xsl:attribute>
						</xsl:element>
						<!-- call helplinks here -->
						<xsl:variable name="constantlinkstring">
							<xsl:value-of select="$namespace"/>.<xsl:value-of select="$constantname"/>
						</xsl:variable>
						<!-- #### calling helplinks #### -->
						<xsl:call-template name="helplinks">
							<xsl:with-param name="linkstring" select="$constantlinkstring"/>
						</xsl:call-template>
						<xsl:value-of select="$vars//localizable/helpattributes"/>
					</xml>
					<META HTTP-EQUIV="Content-Type" Content="text/html; charset=Windows-1252"/>
					<basefont size="2"/>
				</head>
				<!--############################ content block for constant files ####################-->
				<body>
					<title>
						<xsl:value-of select="$constantname"/>
					</title>
					<span class="title">
						<xsl:value-of select="$constantname"/>
						<xsl:text> </xsl:text>
						<xsl:value-of select="$vars//localizable/constant"/>
					</span>
					<!-- #### descrShort ####-->
					<xsl:for-each select="api/descrShort">
						<xsl:apply-templates select="."/>
					</xsl:for-each>
					<xsl:call-template name="referencelink">
						<xsl:with-param name="type" select="$vars//localizable/namespace"/>
						<xsl:with-param name="namespace" select="$namespace"/>
						<xsl:with-param name="value" select="$namespace"/>
					</xsl:call-template>
					<xsl:call-template name="labelsyntax"/>
					<span class="list">
						<p>
							<span class="li">
								<span class="syntax">
									<xsl:call-template name="constvarsyntax">
										<xsl:with-param name="type">constant</xsl:with-param>
									</xsl:call-template>
								</span>
							</span>
						</p>
					</span>
					<!-- #### descrLong #### -->
					<xsl:variable name="longdescription" select="normalize-space(api/descrLong)"/>
					<xsl:if test="string-length (string($longdescription)) > 1">
						<xsl:call-template name="labeldesc"/>
						<xsl:for-each select="api/descrLong">
							<span class="descrLong">
								<xsl:apply-templates select="."/>
							</span>
						</xsl:for-each>
					</xsl:if>
					<xsl:call-template name="footer"/>
				</body>
			</html>
		</xsl:document>
	</xsl:template>
	<!-- ######################### Routine files ####################### -->
	<xsl:template match="/namespace/routine">
		<xsl:variable name="containername" select="../../@name"/>
		<xsl:variable name="containertype" select="name (../..)"/>
		<xsl:variable name="methname" select="@name"/>
		<xsl:variable name="methstring" select="concat('html/', /namespace/@name, $methname)"/>
		<xsl:variable name="methstripped" select="translate($methstring, '.', '')"/>
		<xsl:variable name="methfile" select="concat('uncleaned_',$methstripped, 'Routine.htm')"/>
		<!-- This produces method files -->
		<xsl:document method="xml" indent="yes" href="{$methfile}">
			<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp" DIR="LTR">
				<head>
					<link rel="stylesheet" type="text/css" href="../common/bdshelp.css"/>
					<SCRIPT SRC="../common/linker.js">
						<xsl:text> </xsl:text>
					</SCRIPT>
					<xml>
						<xsl:element name="MSHelp:TOCTitle">
							<xsl:attribute name="Title"><xsl:value-of select="$methname"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/routine"/></xsl:attribute>
						</xsl:element>
						<xsl:element name="MSHelp:RLTitle">
							<xsl:attribute name="Title"><xsl:value-of select="$methname"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/routine"/></xsl:attribute>
						</xsl:element>
						<!-- call helplinks here -->
						<xsl:variable name="methlinkstring">
							<xsl:value-of select="/namespace/@name"/>.<xsl:value-of select="$methname"/>
						</xsl:variable>
						<!-- #### calling helplinks #### -->
						<xsl:call-template name="helplinks">
							<xsl:with-param name="linkstring" select="$methlinkstring"/>
						</xsl:call-template>
						<xsl:value-of select="$vars//localizable/helpattributes"/>
					</xml>
					<META HTTP-EQUIV="Content-Type" Content="text/html; charset=Windows-1252"/>
					<basefont size="2"/>
				</head>
				<body>
					<title>
						<!-- if it is a constructor, label it as such-->
						<xsl:value-of select="$methname"/>
						<xsl:text> </xsl:text>
						<xsl:value-of select="$vars//localizable/routine"/>
					</title>
					<span class="title">
						<xsl:value-of select="$methname"/>
						<xsl:text> </xsl:text>
						<xsl:value-of select="$vars//localizable/routine"/>
					</span>
					<xsl:for-each select="api/descrShort">
						<span class="para">
							<xsl:apply-templates select="."/>
						</span>
					</xsl:for-each>
					<xsl:call-template name="referencelink">
						<xsl:with-param name="type" select="$vars//localizable/namespace"/>
						<xsl:with-param name="namespace" select="ancestor::namespace/@name"/>
						<xsl:with-param name="value" select="ancestor::namespace/@name"/>
					</xsl:call-template>
					<xsl:call-template name="labelsyntax"/>
					<span class="list">
						<xsl:for-each select="syntax">
							<p>
								<span class="li">
									<span class="syntax">
										<xsl:call-template name="methodsyntax"/>
									</span>
								</span>
							</p>
						</xsl:for-each>
					</span>
					<xsl:variable name="longdescription" select="normalize-space(api/descrLong)"/>
					<xsl:if test="string-length (string($longdescription)) > 1">
						<xsl:call-template name="labeldesc"/>
						<xsl:for-each select="api/descrLong">
							<span class="para">
								<xsl:apply-templates select="."/>
							</span>
						</xsl:for-each>
					</xsl:if>
					<xsl:call-template name="footer"/>
				</body>
			</html>
		</xsl:document>
	</xsl:template>
	<!-- #################### helplinks ############################# -->
	<!-- ############################################################ -->
	<!-- this is a recursive template that first builds a help link,
     then strips everything before the first dot and calls itself
     with the remaining string, until the string is empty. So something
     like Borland.Data.Schema.ColumnType would become:
     Borland.Data.Schema.ColumnType
     Data.Schema.ColumnType
     Schema.ColumnType
     ColumnType   with a help link for each.-->
	<xsl:template name="helplinks">
		<xsl:param name="linkstring"/>
		<xsl:if test="not($linkstring='')">
			<!-- build link -->
			<xsl:element name="MSHelp:Keyword">
				<xsl:attribute name="Index">K</xsl:attribute>
				<xsl:attribute name="Term"><xsl:value-of select="$linkstring"/></xsl:attribute>
			</xsl:element>
			<xsl:element name="MSHelp:Keyword">
				<xsl:attribute name="Index">F</xsl:attribute>
				<xsl:attribute name="Term"><xsl:value-of select="$linkstring"/></xsl:attribute>
			</xsl:element>
			<xsl:element name="MSHelp:Keyword">
				<xsl:attribute name="Index">A</xsl:attribute>
				<xsl:attribute name="Term"><xsl:value-of select="$linkstring"/></xsl:attribute>
			</xsl:element>
			<!-- strip to first . -->
			<xsl:variable name="newstring" select="substring-after($linkstring, '.')"/>
			<!-- call helplinks -->
			<xsl:call-template name="helplinks">
				<xsl:with-param name="linkstring" select="$newstring"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<!-- #################### syntax templates ###################### -->
	<!-- ############################################################ -->
	<!-- ######### variables and constants ###### -->
	<xsl:template name="constvarsyntax">
		<xsl:param name="type"/>
		<xsl:if test="$type='variable'">
			<xsl:text>var </xsl:text>
			<b>
				<xsl:value-of select="@name"/>
			</b>
			<xsl:text>: </xsl:text>
			<xsl:value-of select="@type"/>
			<xsl:text>;</xsl:text>
		</xsl:if>
		<xsl:if test="$type='constant'">
			<xsl:text>const </xsl:text>
			<b>
				<xsl:value-of select="@name"/>
			</b>
			<xsl:text>: </xsl:text>
			<xsl:value-of select="@type"/>
			<xsl:text> = </xsl:text>
			<xsl:value-of select="normalize-space(value/text())"/>
			<xsl:text>;</xsl:text>
		</xsl:if>
	</xsl:template>
	<!-- ######### classes and interfaces and types ########### -->
	<xsl:template name="containersyntax">
		<xsl:param name="type"/>
		<!-- no visibility in declaration -->
		<xsl:if test="contains($DevLang,'Delphi')">
		<xsl:text>type</xsl:text>
		<xsl:text> </xsl:text>
		<b>
			<xsl:value-of select="@name"/>
		</b>
		<xsl:text> = </xsl:text>
		<xsl:choose>
			<xsl:when test="$type='class' or $type='interface'">
				<xsl:value-of select="$type"/>
				<xsl:if test="hierarchy/ancestor/class or interfaces/implements/@name">
					<xsl:text> (</xsl:text>
					<xsl:for-each select="hierarchy/ancestor[1]">
						<!-- no multiple inheritance, so only one ancestor -->
						<xsl:value-of select="./namespace"/>
						<xsl:text>.</xsl:text>
						<xsl:value-of select="./class"/>
					</xsl:for-each>
					<xsl:if test="interfaces/implements/@name">
						<xsl:for-each select="interfaces/implements">
							<xsl:if test="position()=1">
								<xsl:if test="../../hierarchy/ancestor/class">
									<xsl:text>, </xsl:text>
								</xsl:if>
							</xsl:if>
							<xsl:if test="@namespace">
								<xsl:value-of select="@namespace"/>
								<xsl:text>.</xsl:text>
							</xsl:if>
							<xsl:value-of select="@name"/>
							<xsl:if test="position() != last()">
								<xsl:text>, </xsl:text>
							</xsl:if>
						</xsl:for-each>
					</xsl:if>
					<xsl:text>)</xsl:text>
				</xsl:if>
				<xsl:text>;</xsl:text>
			</xsl:when>
			<xsl:when test="$type='type' and @variety='type'">
				<xsl:value-of select="@type"/>
				<xsl:text>;</xsl:text>
			</xsl:when>
			<xsl:when test="$type='type' and @variety='array'">
				<xsl:text>array of </xsl:text>
				<xsl:value-of select="./element/@type"/>
			</xsl:when>
			<xsl:when test="$type='type' and @variety='classref'">
				<xsl:text>class of </xsl:text>
				<xsl:value-of select="@ref"/>
			</xsl:when>
			<xsl:when test="$type='type' and (@variety='struct' or @variety='record' or @variety='structure')">
				<xsl:text>record&#xa;</xsl:text>
				<xsl:for-each select="members/field">
					<xsl:value-of select="@type"/>
					<xsl:text>: </xsl:text>
					<xsl:value-of select="@name"/>
					<xsl:text>;&#xa;</xsl:text>
				</xsl:for-each>
				<xsl:text>end;</xsl:text>
			</xsl:when>
			<xsl:when test="$type='type' and @variety='enum'">
				<xsl:text>(</xsl:text>
				<xsl:value-of select="element[1]/@name"/>
				<xsl:for-each select="element">
					<xsl:if test="position() > 1">
						<xsl:text>, </xsl:text>
						<xsl:value-of select="@name"/>
					</xsl:if>
				</xsl:for-each>
				<xsl:text>);</xsl:text>
			</xsl:when>
			<xsl:when test="$type='type' and @variety='set'">
				<xsl:text>set of (</xsl:text>
				<xsl:choose>
					<xsl:when test="@type">
						<xsl:value-of select="@type"/>
						<xsl:text>;</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="element[1]/@name"/>
						<xsl:for-each select="element">
							<xsl:if test="position() > 1">
								<xsl:text>, </xsl:text>
								<xsl:value-of select="@name"/>
							</xsl:if>
						</xsl:for-each>
						<xsl:text>);</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>
          **************************************************************
          Unrecognized type in containersyntax: <xsl:copy-of select="."/>
          **************************************************************
      </xsl:message>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:variable name="flags">
			<flags>
				<flag>sealed</flag>
				<flag>abstract</flag>
				<flag>experimental</flag>
			</flags>
		</xsl:variable>
		<xsl:call-template name="insertflags">
			<xsl:with-param name="flaglist" select="$flags"/>
		</xsl:call-template>
		</xsl:if>
		<xsl:if test="contains($DevLang,'CSharp')">
				<xsl:choose>
					<!-- decide whether to "fake it" on the visibility -->
					<xsl:when test="string-length(./syntax/visibility) &lt; 1">
						<xsl:text>public</xsl:text>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="./syntax/visibility"/>
					</xsl:otherwise>
				</xsl:choose>
				<!--flags need special treatment-->
				<!-- flags handled here: sealed, abstract (cannot be both)-->
                                <xsl:variable name="flags">
                                  <flags>
                                    <printflag>sealed</printflag>
                                    <printflag>abstract</printflag>
                                  </flags>
				</xsl:variable>
				<xsl:call-template name="insertflags">
					<xsl:with-param name="flaglist" select="$flags"/>
                                        <xsl:with-param name="currentflags" select="syntax/flags"/>
				</xsl:call-template>
				<xsl:text> </xsl:text>
				<xsl:value-of select="@variety"/>
				<xsl:text> </xsl:text>
				<b>
					<xsl:value-of select="@name"/>;</b>
		</xsl:if>
	</xsl:template>
	<xsl:template name="previousmatchingarrayprop">
		<!-- if a read parameter, exclude any previous write
       arrayprop siblings that have all but the
       last parameter/@type equal to corresponding \
       parameter/@type in this arrayprop -->
		<!-- if a write parameter, exclude any previous read
       arrayprop siblings that have all of their
       parameter/@type's equal to the 1st through 
       2nd-to-last parameter/@type of this arrayprop -->
		<xsl:variable name="thisarrayprop">
			<xsl:copy-of select="."/>
		</xsl:variable>
		<xsl:variable name="lastpos">
			<xsl:choose>
				<xsl:when test="$thisarrayprop/arrayprop/@variety='read'">
					<xsl:value-of select="count(./parameters/parameter)"/>
				</xsl:when>
				<xsl:otherwise>
					<!-- if a write arrayprop, don't compare last parameter -->
					<xsl:value-of select="count(./parameters/parameter)-1"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<!-- for each previous sibling of another variety... -->
		<xsl:for-each select="preceding-sibling::arrayprop[@variety != $thisarrayprop/arrayprop/@variety]">
			<!-- for each parameter that needs to match -->
			<xsl:for-each select="parameters/parameter">
				<xsl:if test="position() &lt;= $lastpos">
					<xsl:if test="string(@type) = string($thisarrayprop/arrayprop/parameters/parameter[position()]/@type)">
						<xsl:value-of select="'MATCH'"/>
					</xsl:if>
				</xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>
	<!-- ######### properties  ########### -->
	<xsl:template name="propsyntax">
		<!-- need to do this once for each arrayprop tag of each variety-->
		<!-- this is a bit unlike the way overloaded methods are handled because -->
		<!-- an overloaded method will call methodsyntax once for each overload -->
		<!-- but propsyntax is only called once. -->
		<xsl:choose>
			<xsl:when test="./syntax/arrayprop">
				<xsl:if test="count(./syntax/arrayprop[@variety='read']) > 1 or count(./syntax/arrayprop[@variety='write']) > 1">
					<xsl:message>
          OVERLOADED INDEXED PROPERTY: <xsl:copy-of select="."/>
					</xsl:message>
				</xsl:if>
				<span class="list">
					<xsl:for-each select="./syntax/arrayprop">
						<xsl:variable name="previousmatch">
							<!-- if a read parameter, exclude any previous write
                 arrayprop siblings that have all but the
                 last parameter/type equal to corresponding \
                 parameter/@type in this arrayprop -->
							<!-- if a write parameter, exclude any previous read
                 arrayprop siblings that have all of their
                 parameter/@type's equal to the 1st through 
                 2nd-to-last parameter/@type of this arrayprop -->
							<xsl:call-template name="previousmatchingarrayprop"/>
						</xsl:variable>
						<xsl:if test="string-length($previousmatch) = 0">
							<p>
								<span class="li">
									<span class="syntax">
										<xsl:if test="contains($DevLang,'Delphi')">

										<xsl:value-of select="../../@visibility"/>
										<xsl:text> property</xsl:text>
										<xsl:text> </xsl:text>
										<b>
											<xsl:value-of select="../../@name"/>
										</b>
										<xsl:text>[</xsl:text>
										<xsl:value-of select="parameters/parameter[1]/@name"/>
										<xsl:text>: </xsl:text>
										<xsl:value-of select="parameters/parameter[1]/@type"/>
										<xsl:for-each select="./parameter">
											<xsl:if test="position() > 1">
												<xsl:text>, </xsl:text>
												<xsl:value-of select="@name"/>
												<xsl:text>: </xsl:text>
												<xsl:value-of select="@type"/>
											</xsl:if>
										</xsl:for-each>
										<xsl:text>]</xsl:text>
										<xsl:text>: </xsl:text>
										<xsl:value-of select="../../@type"/>
										<xsl:if test="../../@index/text()">
											<xsl:text> index </xsl:text>
											<xsl:value-of select="ancestor::property/@index/text()"/>
										</xsl:if>
										<xsl:if test="../read">
											<xsl:text> read </xsl:text>
											<b>
												<xsl:value-of select="../read/text()"/>
											</b>
										</xsl:if>
										<xsl:if test="../write">
											<xsl:text> write </xsl:text>
											<b>
												<xsl:value-of select="../write/text()"/>
											</b>
										</xsl:if>
										<xsl:if test="../stored">
											<xsl:text> stored </xsl:text>
											<b>
												<xsl:value-of select="../stored/text()"/>
											</b>
										</xsl:if>
										<xsl:if test="../../@default/text()">
											<xsl:text> default </xsl:text>
											<xsl:value-of select="ancestor::property/@default/text()"/>
										</xsl:if>
										<xsl:text>;</xsl:text>
										<xsl:variable name="flags">
											<flags>
												<flag>platform</flag>
												<flag>deprecated</flag>
												<flag>library</flag>
												<flag>experimental</flag>
											</flags>
										</xsl:variable>
										<xsl:call-template name="insertflags">
											<xsl:with-param name="flaglist" select="$flags"/>
										</xsl:call-template>
									</xsl:if>

										<xsl:if test="contains($DevLang,'CSharp')">
											<p>
												<span class="lang"><xsl:value-of select="$vars//localizable/languagetags/CSharp"/></span>
                                                                                                <xsl:text> </xsl:text>
												<xsl:value-of select="../visibility"/>
												<!--flags need special treatment-->
												<!-- flags handled here: virtual, 
                                                                                     abstract (cannot be abstract and static or virtual), override-->
												<!--note this is very language specific (for C#)!-->
                                                                                                <xsl:variable name="flags">
                                                                                                  <flags>
                                                                                                    <printflag>static</printflag>
                                                                                                    <printflag>abstract</printflag>
                                                                                                    <printflag>virtual</printflag>
                                                                                                    <printflag>final</printflag>
                                                                                                    <ignoreflag>instance</ignoreflag>
                                                                                                  </flags>
                                                                                                </xsl:variable>
                                                                                                <xsl:call-template name="insertflags">
                                                                                                  <xsl:with-param name="flaglist" select="$flags"/>
                                                                                                  <xsl:with-param name="currentflags" select="../flags"/>
                                                                                                </xsl:call-template>

												<xsl:text> </xsl:text>
												<xsl:value-of select="../type"/>
												<xsl:text> this</xsl:text>
												<xsl:text>[</xsl:text>
												<xsl:for-each select="./param">
													<xsl:value-of select="./@type"/>
													<xsl:text> </xsl:text>
													<xsl:value-of select="./@name"/>
													<xsl:if test="position()!= last()">
														<xsl:text>, </xsl:text>
													</xsl:if>
												</xsl:for-each>
												<xsl:text>]</xsl:text>
												<xsl:text> {</xsl:text>
												<xsl:choose>
													<xsl:when test="boolean(../write/text()) and boolean(../read/text())">
														<xsl:variable name="write" select="../write"/>
														<xsl:variable name="read" select="../read"/>
														<xsl:value-of select="substring-before($read , '_')"/>
														<xsl:text>; </xsl:text>
														<xsl:value-of select="substring-before($write , '_')"/>
														<xsl:text>;</xsl:text>
													</xsl:when>
													<xsl:when test="boolean(../write/text())">
														<xsl:variable name="write" select="../write"/>
														<xsl:value-of select="substring-before($write , '_')"/>
														<xsl:text>;</xsl:text>
													</xsl:when>
													<xsl:when test="boolean(../read/text())">
														<xsl:variable name="read" select="../read"/>
														<xsl:value-of select="substring-before($read , '_')"/>
														<xsl:text>;</xsl:text>
													</xsl:when>
												</xsl:choose>
												<xsl:text>}</xsl:text>
											</p>
										</xsl:if>
									</span>
								</span>
							</p>
						</xsl:if>
					</xsl:for-each>
				</span>
			</xsl:when>
			<xsl:otherwise>
				<span class="list">
					<p>
						<span class="li">
							<span class="syntax">
								<xsl:if test="contains($DevLang,'Delphi')">
										<xsl:text>property</xsl:text>
										<xsl:text> </xsl:text>
										<b>
											<xsl:value-of select="@name"/>
										</b>
										<xsl:text>: </xsl:text>
										<xsl:value-of select="@type"/>
										<xsl:if test="@index/text()">
											<xsl:text> index </xsl:text>
											<xsl:value-of select="@index/text()"/>
										</xsl:if>
										<xsl:if test="syntax/read">
											<xsl:text> read </xsl:text>
											<b>
												<xsl:value-of select="syntax/read/text()"/>
											</b>
										</xsl:if>
										<xsl:if test="syntax/write">
											<xsl:text> write </xsl:text>
											<b>
												<xsl:value-of select="syntax/write/text()"/>
											</b>
										</xsl:if>
										<xsl:if test="syntax/stored">
											<xsl:text> stored </xsl:text>
											<b>
												<xsl:value-of select="syntax/stored/text()"/>
											</b>
										</xsl:if>
										<xsl:if test="@default/text()">
											<xsl:text> default </xsl:text>
											<xsl:value-of select="@default/text()"/>
										</xsl:if>
										<xsl:text>;</xsl:text>
										<xsl:variable name="flags">
											<flags>
												<printflag>platform</printflag>
												<printflag>deprecated</printflag>
												<printflag>library</printflag>
												<printflag>experimental</printflag>
                                                                                                <ignoreflag>instance</ignoreflag>
											</flags>
										</xsl:variable>
										<xsl:call-template name="insertflags">
											<xsl:with-param name="flaglist" select="$flags"/>
                                                                                        <xsl:with-param name="currentflags" select="syntax/flags/text()"/>
										</xsl:call-template>
								</xsl:if>
								
								<xsl:if test="contains($DevLang,'CSharp')">
										<xsl:value-of select="./syntax/visibility"/>
										<!--flags need special treatment-->
										<!-- flags handled here: virtual, 
                                                                                     abstract (cannot be abstract and static or virtual), override-->
										<!--note this is very language specific (for C#)!-->
                                                                                <xsl:variable name="flags">
                                                                                  <flags>
                                                                                    <printflag>static</printflag>
                                                                                    <printflag>abstract</printflag>
                                                                                    <printflag>virtual</printflag>
                                                                                    <printflag>final</printflag>
                                                                                    <ignoreflag>instance</ignoreflag>
                                                                                  </flags>
                                                                                </xsl:variable>
                                                                                <xsl:call-template name="insertflags">
                                                                                  <xsl:with-param name="flaglist" select="$flags"/>
                                                                                  <xsl:with-param name="currentflags" select="syntax/flags"/>
                                                                                </xsl:call-template>
										<xsl:text> </xsl:text>
										<xsl:value-of select="./syntax/type"/>
										<xsl:text> </xsl:text>
										<b>
											<xsl:value-of select="./@name"/>
										</b>
										<xsl:text> {</xsl:text>
										<xsl:choose>
											<xsl:when test="boolean(./syntax/write/text()) and boolean(./syntax/read/text())">
												<xsl:variable name="write" select="./syntax/write"/>
												<xsl:variable name="read" select="./syntax/read"/>
												<xsl:value-of select="substring-before($read , '_')"/>
												<xsl:text>; </xsl:text>
												<xsl:value-of select="substring-before($write , '_')"/>
												<xsl:text>;</xsl:text>
											</xsl:when>
											<xsl:when test="boolean(./syntax/write/text())">
												<xsl:variable name="write" select="./syntax/write"/>
												<xsl:value-of select="substring-before($write , '_')"/>
												<xsl:text>;</xsl:text>
											</xsl:when>
											<xsl:when test="boolean(./syntax/read/text())">
												<xsl:variable name="read" select="./syntax/read"/>
												<xsl:value-of select="substring-before($read , '_')"/>
												<xsl:text>;</xsl:text>
											</xsl:when>
										</xsl:choose>
										<xsl:text>}</xsl:text>
								</xsl:if>								
								
								</span>
								</span>
								</p>
				</span>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<!-- ######### methods ########### -->
	<xsl:template name="methodsyntax">
		<xsl:if test="contains($DevLang,'Delphi')">

		<!-- only enter visibility for methods, not routines -->
		<xsl:if test="not(parent::routine)">
			<xsl:value-of select="../syntax/visibility"/>
			<xsl:text> </xsl:text>
		</xsl:if>
		<xsl:if test="contains(@flags,'class') or contains (@procflags, 'class') or contains (@symflags, 'class')">
			<xsl:text>class </xsl:text>
		</xsl:if>
		<xsl:value-of select="../syntax/variety"/>
		<xsl:text> </xsl:text>
		<b>
			<xsl:value-of select="../syntax/name"/>
		</b>
		<xsl:text>(</xsl:text>
		<xsl:for-each select="parameters/parameter">
			<xsl:if test="@paramflags">
				<xsl:value-of select="@paramflags"/>
				<xsl:text> </xsl:text>
			</xsl:if>
			<xsl:value-of select="./@name"/>
			<xsl:text>: </xsl:text>
			<xsl:choose>
				<xsl:when test="./array">
					<xsl:text>array of </xsl:text>
					<xsl:value-of select="./array/element/@type"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="./@type"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="position()!= last()">
				<xsl:text>, </xsl:text>
			</xsl:if>
		</xsl:for-each>
		<xsl:text>)</xsl:text>
		<xsl:if test="./variety='function' and parameters/retval">
			<xsl:text>: </xsl:text>
			<xsl:choose>
				<xsl:when test="parameters/retval/array">
					<xsl:text>array of </xsl:text>
					<xsl:value-of select="parameters/retval/array/element/@type"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="parameters/retval/@type"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:text>;</xsl:text>
		<xsl:variable name="flags">
			<flags>
				<flag>virtual</flag>
				<flag>final</flag>
				<flag>static</flag>
				<flag>dynamic</flag>
				<flag>override</flag>
				<flag>abstract</flag>
				<flag>reintroduce</flag>
				<flag>overload</flag>
				<flag>experimental</flag>
			</flags>
		</xsl:variable>
		<xsl:call-template name="insertflags">
			<xsl:with-param name="flaglist" select="$flags"/>
		</xsl:call-template>
		</xsl:if>

		<xsl:if test="contains($DevLang,'CSharp')">
            <xsl:if test="../syntax[variety/text()='procedure'] or ../syntax[variety/text()='function']">
						<xsl:value-of select="../syntax/visibility"/>
						<!--flags need special treatment-->
						<!-- flags handled here: virtual, static,
                           abstract (cannot be abstract and static or virtual), override-->
                                                <!--note this is very language specific (for C#)!-->
                                                <xsl:variable name="flags">
                                                  <flags>
                                                    <printflag>static</printflag>
                                                    <printflag>abstract</printflag>
                                                    <printflag>virtual</printflag>
                                                    <printflag>final</printflag>
                                                    <printflag>override</printflag>
                                                    <ignoreflag>instance</ignoreflag>
                                                  </flags>
                                                </xsl:variable>
                                                <xsl:call-template name="insertflags">
                                                  <xsl:with-param name="flaglist" select="$flags"/>
                                                  <xsl:with-param name="currentflags" select="../syntax/@procflags"/>
                                                </xsl:call-template>
						<xsl:text> </xsl:text>
						<xsl:choose>
							<xsl:when test="../syntax/parameters/retval/@type = 'Void'">
								<xsl:text>void</xsl:text>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="../syntax/parameters/retval/@type"/>
							</xsl:otherwise>
						</xsl:choose>
						<xsl:text> </xsl:text>
						<b>
							<xsl:value-of select="../syntax/name"/>
						</b>
						<xsl:text>(</xsl:text>
						<xsl:for-each select="parameters/parameter">
							<xsl:value-of select="./@type"/>
							<xsl:text> </xsl:text>
							<xsl:value-of select="./@name"/>
							<xsl:if test="position()!= last()">
								<xsl:text>, </xsl:text>
							</xsl:if>
						</xsl:for-each>
						<xsl:text>);</xsl:text>
						<!--</p>-->
					</xsl:if>
					<!-- for constructor -->
					<xsl:if test="../syntax[variety/text()='constructor']">
						<!--  <p>-->
						<xsl:value-of select="../syntax/visibility"/>
						<xsl:text> </xsl:text>
						<b>
							<xsl:value-of select="../syntax/name"/>
						</b>
						<xsl:text>(</xsl:text>
						<xsl:for-each select="parameters/parameter">
							<xsl:value-of select="./@type"/>
							<xsl:text> </xsl:text>
							<xsl:value-of select="./@name"/>
							<xsl:if test="position()!= last()">
								<xsl:text>, </xsl:text>
							</xsl:if>
						</xsl:for-each>
						<xsl:text>);</xsl:text>
						<!--  </p>-->
					</xsl:if>
		</xsl:if>

	</xsl:template>
	<!-- ######### eventsyntax ########### -->
	<xsl:template name="eventsyntax">
		<xsl:if test="contains($DevLang,'Delphi')">
		<!-- consider calling methodsyntax here! -->
		<xsl:text>property </xsl:text>
		<b>
			<xsl:value-of select="./syntax/name"/>
		</b>
		<xsl:text>: </xsl:text>
		<xsl:value-of select="./syntax/type"/>
		<xsl:text>;</xsl:text>
		</xsl:if>

		<xsl:if test="contains($DevLang,'CSharp')">
                <xsl:choose>
						<!-- decide whether to "fake it" on the visibility -->
						<xsl:when test="string-length(./visibility) &lt; 1">
							<xsl:text>public</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="./visibility"/>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:text> event </xsl:text>
					<xsl:value-of select="./type"/>
					<xsl:text> </xsl:text>
					<b>
						<xsl:value-of select="../@eventname"/>
					</b>
					<xsl:text>;</xsl:text>
		</xsl:if>

	</xsl:template>
	<!-- ####################### Formatting Templates ######################## -->
	<!-- ##################################################################### -->
	<!-- default template, to keep things like <b> and <list>
             in the output -->
	<xsl:template match="*|@*">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	<!-- #### para #### -->
	<xsl:template match="para">
		<span class="para">
			<xsl:apply-templates/>
		</span>
	</xsl:template>
	<!-- ######################################################################
             name: This is used for name elements within the vars.xml
             file that serve as placeholders for member names.   This allows for
             the grammar of different languages for translation -->
	<xsl:template match="name">
		<xsl:param name="membername"/>
		<xsl:value-of select="$membername"/>
	</xsl:template>
	<!-- #### note #### -->
	<xsl:template match="note">
		<p class="note">
			<xsl:value-of select="$vars//localizable/note"/>
			<xsl:text>: </xsl:text>
			<xsl:for-each select="para">
				<span class="ntwPara">
					<xsl:apply-templates select="*|text()"/>
				</span>
			</xsl:for-each>
		</p>
	</xsl:template>
	<!-- #### tip #### -->
	<xsl:template match="tip">
		<p class="tip">
			<xsl:value-of select="$vars//localizable/tip"/>
			<xsl:text>: </xsl:text>
			<xsl:for-each select="para">
				<span class="ntwPara">
					<xsl:apply-templates select="*|text()"/>
				</span>
			</xsl:for-each>
		</p>
	</xsl:template>
	<!-- #### warning #### -->
	<xsl:template match="warning">
		<p class="warning">
			<xsl:value-of select="$vars//localizable/warning"/>
			<xsl:text>: </xsl:text>
			<xsl:for-each select="para">
				<span class="ntwPara">
					<xsl:apply-templates select="*|text()"/>
				</span>
			</xsl:for-each>
		</p>
	</xsl:template>
	<!-- #### varProduct #### -->
	<xsl:template match="varProduct">
		<xsl:value-of select="$vars//product/productname"/>
	</xsl:template>
	<!-- #### codeBlock #### -->
	<xsl:template match="codeBlock">
		<span class="codeBlock">
			<pre>
				<xsl:value-of select="."/>
			</pre>
		</span>
	</xsl:template>
	<!-- #### codeInline #### -->
	<xsl:template match="codeInline">
		<span class="codeInline">
			<xsl:value-of select="."/>
		</span>
	</xsl:template>
	<xsl:template match="list[@type='numbered']">
		<ol>
			<xsl:apply-templates/>
		</ol>
	</xsl:template>
	<xsl:template match="list[@type='bullet']">
		<ul>
			<xsl:apply-templates/>
		</ul>
	</xsl:template>
	<xsl:template match="item">
		<li>
			<xsl:apply-templates/>
		</li>
	</xsl:template>
	<!-- #### table handling #### -->
	<xsl:template match="td">
		<td>
			<xsl:apply-templates/>
		</td>
	</xsl:template>
	<xsl:template match="para[parent::td]">
		<span class="tablePara">
			<xsl:apply-templates select="*|text()"/>
		</span>
	</xsl:template>
	<xsl:template match="table | tr | th">
		<span class="{name()}">
			<xsl:copy>
				<xsl:apply-templates select="*|text()"/>
			</xsl:copy>
		</span>
	</xsl:template>
	<!--####End of table handling######-->
	<!-- #### class #### -->
	<xsl:template match="class[not(ancestor::descrLong or ancestor::descrShort) and not(parent::namespace)]">
		<span class="classname">
			<xsl:apply-templates/>
		</span>
	</xsl:template>
	<!--Comments are excluded from the output.-->
	<xsl:template match="comment"/>
	<!-- #### footer #### -->
	<xsl:template name="footer">
		<!--new copyright @5/15-->
		<br/>
		<br/>
		<nowrap>
			<span style="font-size:70%; border-top: 1.2pt groove">
				<xsl:apply-templates select="$vars//copyrightMessage/* | $vars//copyrightMessage/text()"/>
			</span>
		</nowrap>
		<br/>
		<br/>
	</xsl:template>
	<!-- #### msicon #### -->
	<xsl:template name="msicon">
		<span class="imageInline">
			<xsl:element name="img">
				<xsl:attribute name="src"><xsl:value-of select="$vars//linktypes//image"/><xsl:value-of select="$vars//linkicons//sdk//@file"/></xsl:attribute>
				<xsl:attribute name="alt"><xsl:value-of select="$vars//linkicons//sdk"/></xsl:attribute>
				<xsl:attribute name="width"><xsl:value-of select="$vars//linkicons//sdk//@width"/></xsl:attribute>
				<xsl:attribute name="height"><xsl:value-of select="$vars//linkicons//sdk//@height"/></xsl:attribute>
				<xsl:attribute name="border">none</xsl:attribute>
				<xsl:attribute name="align">absbottom</xsl:attribute>
			</xsl:element>
		</span>
	</xsl:template>
	<!-- referencelink-->
	<xsl:template name="referencelink">
		<xsl:param name="type"/>
		<xsl:param name="namespace"/>
		<xsl:param name="value"/>
		<!-- list the namespace/class  -->
		<b>
			<xsl:value-of select="$type"/>
		</b>
		<span class="list">
			<span class="link">
				<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
				<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
					<xsl:attribute name="keywords"><xsl:choose><xsl:when test="$type = $vars//localizable/namespace"><xsl:value-of select="$value"/></xsl:when><xsl:otherwise><xsl:value-of select="concat($namespace, '.', $value)"/></xsl:otherwise></xsl:choose></xsl:attribute>
					<xsl:value-of select="$value"/>
				</MSHelp:link>
			</span>
		</span>
	</xsl:template>
	<xsl:template name="labeldesc">
		<b>
			<xsl:value-of select="$vars//localizable/longDesc"/>
		</b>
	</xsl:template>
	<xsl:template name="labelsyntax">
		<p> </p>
		<b>
			<xsl:value-of select="$vars//localizable/syntax"/>
		</b>
	</xsl:template>
	<xsl:template name="insertflags">
		<xsl:param name="flaglist"/>
		<!-- look for all possible flags, in order -->
		<xsl:for-each select="$flaglist/flags/flag">
			<xsl:variable name="text" select="./text()"/>
			<xsl:if test="descendant::*[text()=$text or name(.)=$text]">
				<xsl:text> </xsl:text>
				<xsl:value-of select="."/>
				<xsl:text>;</xsl:text>
			</xsl:if>
		</xsl:for-each>
		<!-- look for unexpected flags -->
		<xsl:for-each select="saxon:tokenize(./syntax/flags,' ')">
			<xsl:variable name="flag" select="./text()"/>
			<xsl:if test="not($flaglist/flags/flag[text()=$flag])">
				<xsl:message>
        Warning: unrecognized flag <xsl:value-of select="$flag"/>:  <xsl:value-of select="saxon:path()"/>
      File <xsl:value-of select="saxon:system-id()"/>
				</xsl:message>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="varietytotitle">
		<xsl:param name="variety"/>
		<xsl:choose>
			<xsl:when test="$variety='enum'">
				<xsl:value-of select="$vars//localizable/enum"/>
			</xsl:when>
			<xsl:when test="$variety='struct'">
				<xsl:value-of select="$vars//localizable/record"/>
			</xsl:when>
			<xsl:when test="$variety='classref'">
				<xsl:value-of select="$vars//localizable/classref"/>
			</xsl:when>
			<xsl:when test="$variety='set'">
				<xsl:value-of select="$vars//localizable/set"/>
			</xsl:when>
			<xsl:when test="$variety='array'">
				<xsl:value-of select="$vars//localizable/array"/>
			</xsl:when>
			<xsl:when test="$variety='type'">
				<xsl:value-of select="$vars//localizable/type"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>
*************************************************************************
                ALERT! UNNAMED VARIETY <xsl:value-of select="$variety"/>
*************************************************************************
              </xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="insertparentlinks">
		<xsl:param name="namespace"/>
		<xsl:param name="containername"/>
		<xsl:param name="containertype"/>
		<span class="listedLink">
			<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
			<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
				<xsl:attribute name="keywords"><xsl:value-of select="$namespace"/>.<xsl:value-of select="$containername"/></xsl:attribute>
				<xsl:choose>
					<xsl:when test="$containertype='Class'">
						<xsl:apply-templates select="$vars//localizable/class/node()">
							<xsl:with-param name="membername" select="$containername"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:when test="$containertype='Interface'">
						<xsl:apply-templates select="$vars//localizable/interface/node()">
							<xsl:with-param name="membername" select="$containername"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<xsl:message>
$containertype "<xsl:value-of select="$containertype"/>" not supported in insertparentlinks template
          </xsl:message>
					</xsl:otherwise>
				</xsl:choose>
			</MSHelp:link>
		</span>
	</xsl:template>
	<xsl:template name="insertmemberlinks">
		<xsl:param name="namespace"/>
		<xsl:param name="containername"/>
		<xsl:param name="membertype"/>
		<xsl:if test="(members/property | propertylinks/propertylink) and $membertype!='Property'">
			<span class="listedLink">
				<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
				<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
					<xsl:attribute name="keywords"><xsl:value-of select="$namespace"/>.<xsl:value-of select="$containername"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/properties"/></xsl:attribute>
					<xsl:apply-templates select="$vars//localizable/Propertiesof/node()">
						<xsl:with-param name="membername" select="$containername"/>
					</xsl:apply-templates>
				</MSHelp:link>
			</span>
		</xsl:if>
		<xsl:if test="(members/method | methodlinks/methodlink) and $membertype!='Method'">
			<span class="listedLink">
				<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
				<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
					<xsl:attribute name="keywords"><xsl:value-of select="$namespace"/>.<xsl:value-of select="$containername"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/methods"/></xsl:attribute>
					<xsl:apply-templates select="$vars//localizable/Methodsof/node()">
						<xsl:with-param name="membername" select="$containername"/>
					</xsl:apply-templates>
				</MSHelp:link>
			</span>
		</xsl:if>
		<xsl:if test="(members/event | eventlinks/eventlink) and $membertype != 'Event'">
			<span class="listedLink">
				<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
				<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
					<xsl:attribute name="keywords"><xsl:value-of select="$namespace"/>.<xsl:value-of select="$containername"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/events"/></xsl:attribute>
					<xsl:apply-templates select="$vars//localizable/Eventsof/node()">
						<xsl:with-param name="membername" select="$containername"/>
					</xsl:apply-templates>
				</MSHelp:link>
			</span>
		</xsl:if>
		<xsl:if test="$membertype != 'Members'">
			<span class="listedLink">
				<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
				<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
					<xsl:attribute name="keywords"><xsl:value-of select="$namespace"/>.<xsl:value-of select="$containername"/><xsl:text> </xsl:text><xsl:value-of select="$vars//localizable/Members"/></xsl:attribute>
					<xsl:apply-templates select="$vars//localizable/Allmembersof/node()">
						<xsl:with-param name="membername" select="$containername"/>
					</xsl:apply-templates>
				</MSHelp:link>
			</span>
		</xsl:if>
	</xsl:template>
	<xsl:template name="makemembersfile">
		<xsl:param name="namespace"/>
		<xsl:param name="containername"/>
		<xsl:param name="containertype"/>
		<xsl:param name="stripped"/>
		<xsl:variable name="membersfile">
			<xsl:value-of select="concat('uncleaned_',$stripped, 'Members.htm')"/>
		</xsl:variable>
		<xsl:document method="xml" indent="yes" href="{$membersfile}">
			<html xmlns:MSHelp="http://msdn.microsoft.com/mshelp" DIR="LTR">
				<head>
					<link rel="stylesheet" type="text/css" href="../common/bdshelp.css"/>
					<SCRIPT SRC="../common/linker.js">
						<xsl:text> </xsl:text>
					</SCRIPT>
					<xml>
						<xsl:element name="MSHelp:TOCTitle">
							<xsl:attribute name="Title"><xsl:apply-templates select="$vars//localizable/Members/node()"><xsl:with-param name="membername" select="$containername"/></xsl:apply-templates></xsl:attribute>
						</xsl:element>
						<xsl:element name="MSHelp:RLTitle">
							<xsl:attribute name="Title"><xsl:apply-templates select="$vars//localizable/Members/node()"><xsl:with-param name="membername" select="$containername"/></xsl:apply-templates></xsl:attribute>
						</xsl:element>
						<xsl:variable name="linkstring">
							<xsl:value-of select="$namespace"/>.<xsl:value-of select="$containername"/>
							<xsl:text> </xsl:text>
							<xsl:value-of select="$vars//localizable/members"/>
						</xsl:variable>
						<!-- #### calling helplinks #### -->
						<xsl:call-template name="helplinks">
							<xsl:with-param name="linkstring" select="$linkstring"/>
						</xsl:call-template>
						<xsl:value-of select="$vars//localizable/helpattributes"/>
					</xml>
					<META HTTP-EQUIV="Content-Type" Content="text/html; charset=Windows-1252"/>
					<basefont size="2"/>
				</head>
				<!--####### content block for member files #########-->
				<body>
					<title>
						<xsl:apply-templates select="$vars//localizable/Members/node()">
							<xsl:with-param name="membername" select="$containername"/>
						</xsl:apply-templates>
					</title>
					<span class="title">
						<xsl:apply-templates select="$vars//localizable/Members/node()">
							<xsl:with-param name="membername" select="$containername"/>
						</xsl:apply-templates>
					</span>
					<!-- ########## propertylinks ########## -->
					<!-- collecting in a variable so they can all be sorted-->
					<xsl:variable name="linknode">
						<!-- ########## property links ######### -->
						<xsl:for-each select="propertylinks/propertylink[not(property=following-sibling::propertylink/property) and not(../../members/property/@name=property)]">
							<xsl:variable name="proplinkname" select="property/text()"/>
							<xsl:if test="not(../../members/property[@name=$proplinkname])">
								<xsl:element name="inheritedlink">
									<xsl:copy-of select="@declaring_interface"/>
									<xsl:attribute name="namespace"><xsl:value-of select="namespace"/></xsl:attribute>
									<xsl:attribute name="class"><xsl:value-of select="class"/></xsl:attribute>
									<xsl:if test="@docset='microsoft'">
										<xsl:element name="link">
											<xsl:attribute name="type"><xsl:value-of select="$vars//localizable/property"/></xsl:attribute>
											<span class="link">
												<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
												<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
													<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="property"/></xsl:attribute>
													<xsl:value-of select="property"/>
													<xsl:if test="boolean(@declaring_interface)">
														<span class="pt">
															<xsl:text> (</xsl:text>
															<xsl:value-of select="@declaring_interface"/>
															<xsl:text>)</xsl:text>
														</span>
													</xsl:if>
												</MSHelp:link>
											</span>
											<mslink>
												<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
												<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
													<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="property"/></xsl:attribute>
													<xsl:apply-templates select="$vars//localizable/Inheritedfrom/node()">
														<xsl:with-param name="membername">
															<xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>
														</xsl:with-param>
													</xsl:apply-templates>
													<xsl:call-template name="msicon"/>
												</MSHelp:link>
											</mslink>
											<xsl:copy-of select="descrShort"/>
										</xsl:element>
									</xsl:if>
									<xsl:if test="@docset='borland'">
										<xsl:element name="link">
											<xsl:attribute name="type"><xsl:value-of select="$vars//localizable/property"/></xsl:attribute>
											<span class="link">
												<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
												<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
													<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="property"/></xsl:attribute>
													<xsl:value-of select="property"/>
													<xsl:if test="boolean(@declaring_interface)">
														<span class="pt">
															<xsl:text> (</xsl:text>
															<xsl:value-of select="@declaring_interface"/>
															<xsl:text>)</xsl:text>
														</span>
													</xsl:if>
												</MSHelp:link>
											</span>
											<xsl:copy-of select="descrShort"/>
										</xsl:element>
									</xsl:if>
								</xsl:element>
							</xsl:if>
						</xsl:for-each>
						<!-- ########## member properties ########-->
						<!-- avoids repeating indexers which are "overloaded" -->
						<xsl:for-each select="members/property[not(@name=following-sibling::property/@name)]">
							<xsl:element name="link">
								<xsl:attribute name="type"><xsl:value-of select="$vars//localizable/property"/></xsl:attribute>
								<span class="link">
									<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
									<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
										<xsl:attribute name="keywords"><xsl:value-of select="$namespace"/>.<xsl:value-of select="$containername"/>.<xsl:value-of select="@name"/></xsl:attribute>
										<xsl:value-of select="@name"/>
										<xsl:if test="boolean(@declaring_interface)">
											<span class="pt">
												<xsl:text> (</xsl:text>
												<xsl:value-of select="@declaring_interface"/>
												<xsl:text>)</xsl:text>
											</span>
										</xsl:if>
									</MSHelp:link>
								</span>
								<xsl:copy-of select="./api/descrShort"/>
							</xsl:element>
						</xsl:for-each>
						<!-- METHOD LINKS -->
						<xsl:for-each select="methodlinks/methodlink[not(method=following-sibling::methodlink/method) and not(../../members/method/@name=method)]">
							<xsl:variable name="methlinkname" select="method/text()"/>
							<xsl:if test="not(../../members/method[@name=$methlinkname])">
								<xsl:element name="inheritedlink">
									<xsl:copy-of select="@declaring_interface"/>
									<xsl:attribute name="namespace"><xsl:value-of select="namespace"/></xsl:attribute>
									<xsl:attribute name="class"><xsl:value-of select="class"/></xsl:attribute>
									<xsl:if test="@docset='microsoft'">
										<xsl:element name="link">
											<xsl:attribute name="type"><xsl:value-of select="$vars//localizable/method"/></xsl:attribute>
											<span class="link">
												<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
												<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
													<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="method"/></xsl:attribute>
													<xsl:value-of select="method"/>
													<xsl:if test="count(syntax)&gt;1">
														<span class="pt">
															<xsl:text> (</xsl:text>
															<xsl:value-of select="$vars//localizable/overloaded"/>
															<xsl:text>)</xsl:text>
														</span>
													</xsl:if>
													<xsl:if test="boolean(@declaring_interface)">
														<span class="pt">
															<xsl:text> (</xsl:text>
															<xsl:value-of select="@declaring_interface"/>
															<xsl:text>)</xsl:text>
														</span>
													</xsl:if>
												</MSHelp:link>
											</span>
											<mslink>
												<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
												<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
													<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="method"/></xsl:attribute>
													<xsl:apply-templates select="$vars//localizable/Inheritedfrom/node()">
														<xsl:with-param name="membername">
															<xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>
														</xsl:with-param>
													</xsl:apply-templates>
													<xsl:call-template name="msicon"/>
												</MSHelp:link>
											</mslink>
											<xsl:copy-of select="descrShort"/>
										</xsl:element>
									</xsl:if>
									<xsl:if test="@docset='borland'">
										<xsl:element name="link">
											<xsl:attribute name="type"><xsl:value-of select="$vars//localizable/method"/></xsl:attribute>
											<span class="link">
												<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
												<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
													<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="method"/></xsl:attribute>
													<xsl:value-of select="method"/>
													<xsl:if test="count(syntax)&gt;1">
														<span class="pt">
															<xsl:text> (</xsl:text>
															<xsl:value-of select="$vars//localizable/overloaded"/>
															<xsl:text>)</xsl:text>
														</span>
													</xsl:if>
													<xsl:if test="boolean(@declaring_interface)">
														<span class="pt">
															<xsl:text> (</xsl:text>
															<xsl:value-of select="@declaring_interface"/>
															<xsl:text>)</xsl:text>
														</span>
													</xsl:if>
												</MSHelp:link>
											</span>
											<xsl:copy-of select="descrShort"/>
										</xsl:element>
									</xsl:if>
								</xsl:element>
							</xsl:if>
						</xsl:for-each>
						<!-- ########## member methods ########-->
						<!-- avoids repeating indexers which are "overloaded" -->
						<xsl:for-each select="members/method[not(@name=following-sibling::method/@name)]">
							<xsl:element name="link">
								<xsl:attribute name="type"><xsl:value-of select="$vars//localizable/method"/></xsl:attribute>
								<span class="link">
									<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
									<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
										<xsl:attribute name="keywords"><xsl:value-of select="$namespace"/>.<xsl:value-of select="$containername"/>.<xsl:value-of select="@name"/></xsl:attribute>
										<xsl:value-of select="@name"/>
										<xsl:if test="boolean(@declaring_interface)">
											<span class="pt">
												<xsl:text> (</xsl:text>
												<xsl:value-of select="@declaring_interface"/>
												<xsl:text>)</xsl:text>
											</span>
										</xsl:if>
									</MSHelp:link>
								</span>
								<xsl:copy-of select="./api/descrShort"/>
							</xsl:element>
						</xsl:for-each>
						<!-- ########## eventlinks ########## -->
						<xsl:for-each select="eventlinks/eventlink[not(event=following-sibling::eventlink/event) and not(../../members/event/@name=event)]">
							<xsl:variable name="eventlinkname" select="event/text()"/>
							<xsl:if test="not(../../members/event[@name=$eventlinkname])">
								<xsl:element name="inheritedlink">
									<xsl:copy-of select="@declaring_interface"/>
									<xsl:attribute name="namespace"><xsl:value-of select="namespace"/></xsl:attribute>
									<xsl:attribute name="class"><xsl:value-of select="class"/></xsl:attribute>
									<xsl:if test="@docset='microsoft'">
										<xsl:element name="link">
											<xsl:attribute name="type"><xsl:value-of select="$vars//localizable/event"/></xsl:attribute>
											<span class="link">
												<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
												<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
													<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="event"/></xsl:attribute>
													<xsl:value-of select="event"/>
													<xsl:if test="boolean(@declaring_interface)">
														<span class="pt">
															<xsl:text> (</xsl:text>
															<xsl:value-of select="@declaring_interface"/>
															<xsl:text>)</xsl:text>
														</span>
													</xsl:if>
												</MSHelp:link>
											</span>
											<mslink>
												<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
												<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
													<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="event"/></xsl:attribute>
													<xsl:apply-templates select="$vars//localizable/Inheritedfrom/node()">
														<xsl:with-param name="membername">
															<xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>
														</xsl:with-param>
													</xsl:apply-templates>
													<xsl:call-template name="msicon"/>
												</MSHelp:link>
											</mslink>
											<xsl:copy-of select="descrShort"/>
										</xsl:element>
									</xsl:if>
									<xsl:if test="@docset='borland'">
										<xsl:element name="link">
											<xsl:attribute name="type"><xsl:value-of select="$vars//localizable/event"/></xsl:attribute>
											<span class="link">
												<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
												<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
													<xsl:attribute name="keywords"><xsl:value-of select="namespace"/>.<xsl:value-of select="class | interface"/>.<xsl:value-of select="event"/></xsl:attribute>
													<xsl:value-of select="event"/>
													<xsl:if test="boolean(@declaring_interface)">
														<span class="pt">
															<xsl:text> (</xsl:text>
															<xsl:value-of select="@declaring_interface"/>
															<xsl:text>)</xsl:text>
														</span>
													</xsl:if>
												</MSHelp:link>
											</span>
											<xsl:copy-of select="descrShort"/>
										</xsl:element>
									</xsl:if>
								</xsl:element>
							</xsl:if>
						</xsl:for-each>
						<!-- ########## member events ########-->
						<!-- 07/02/03 SN modified to avoid repeating indexers which are "overloaded" -->
						<xsl:for-each select="members/event[not(@name=following-sibling::event/@name)]">
							<xsl:element name="link">
								<xsl:attribute name="type"><xsl:value-of select="$vars//localizable/event"/></xsl:attribute>
								<span class="link">
									<!--<MSHelp:link namespace="ms-help://borland.bds2" indexMoniker="!DefaultContextWindowIndex">-->
									<MSHelp:link indexMoniker="!DefaultContextWindowIndex">
										<xsl:attribute name="keywords"><xsl:value-of select="$namespace"/>.<xsl:value-of select="$containername"/>.<xsl:value-of select="@name"/></xsl:attribute>
										<xsl:value-of select="@name"/>
										<xsl:if test="boolean(@declaring_interface)">
											<span class="pt">
												<xsl:text> (</xsl:text>
												<xsl:value-of select="@declaring_interface"/>
												<xsl:text>)</xsl:text>
											</span>
										</xsl:if>
									</MSHelp:link>
								</span>
								<xsl:copy-of select="./api/descrShort"/>
							</xsl:element>
						</xsl:for-each>
					</xsl:variable>
					<!-- ALL MEMBERS -->
					<xsl:if test="boolean($linknode/link/span/MSHelp:link | $linknode/inheritedlink/link/span/MSHelp:link)">
						<span class="linkList">
							<xsl:value-of select="$vars//localizable/Membersof"/>
							<xsl:text> </xsl:text>
							<xsl:value-of select="$containername"/>
							<table class="regular">
								<xsl:for-each select="$linknode/link/span | $linknode/inheritedlink/link/span">
									<xsl:sort select="MSHelp:link/text()"/>
									<tr>
										<td class="regular">
										<span class="tablePara">
											<xsl:copy-of select="."/>
											<xsl:text> </xsl:text>
											<xsl:value-of select="../@type"/>
											</span>
										</td>
										<td class="regular">
										<span class="tablePara">
											<xsl:copy-of select="../descrShort/*"/>
											<xsl:copy-of select="../mslink"/>
											</span>
										</td>
									</tr>
								</xsl:for-each>
							</table>
						</span>
					</xsl:if>
					<span class="linkList">
						<xsl:value-of select="$vars//localizable//linkList"/>
						<xsl:call-template name="insertparentlinks">
							<xsl:with-param name="namespace" select="$namespace"/>
							<xsl:with-param name="containername" select="$containername"/>
							<xsl:with-param name="containertype" select="$containertype"/>
						</xsl:call-template>
						<xsl:call-template name="insertmemberlinks">
							<xsl:with-param name="namespace" select="$namespace"/>
							<xsl:with-param name="containername" select="$containername"/>
							<xsl:with-param name="membertype" select="'Members'"/>
						</xsl:call-template>
					</span>
					<xsl:call-template name="footer"/>
				</body>
			</html>
		</xsl:document>
	</xsl:template>
</xsl:stylesheet>
